/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.troja.eve.esi.JSON;

public class CharacterCalendarResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_EVENT_DATE = "event_date";
    @SerializedName(value="event_date")
    @Nullable
    private OffsetDateTime eventDate;
    public static final String SERIALIZED_NAME_EVENT_ID = "event_id";
    @SerializedName(value="event_id")
    @Nullable
    private Integer eventId;
    public static final String SERIALIZED_NAME_EVENT_RESPONSE = "event_response";
    @SerializedName(value="event_response")
    @Nullable
    private String eventResponse;
    private EventResponseEnum eventResponseEnum;
    public static final String SERIALIZED_NAME_IMPORTANCE = "importance";
    @SerializedName(value="importance")
    @Nullable
    private Integer importance;
    public static final String SERIALIZED_NAME_TITLE = "title";
    @SerializedName(value="title")
    @Nullable
    private String title;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CharacterCalendarResponse eventDate(@Nullable OffsetDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @Nullable
    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(@Nullable OffsetDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public CharacterCalendarResponse eventId(@Nullable Integer eventId) {
        this.eventId = eventId;
        return this;
    }

    @Nullable
    public Integer getEventId() {
        return this.eventId;
    }

    public void setEventId(@Nullable Integer eventId) {
        this.eventId = eventId;
    }

    public CharacterCalendarResponse eventResponse(@Nullable EventResponseEnum eventResponse) {
        this.eventResponseEnum = eventResponse;
        return this;
    }

    public CharacterCalendarResponse eventResponseString(@Nullable String eventResponse) {
        this.eventResponse = eventResponse;
        return this;
    }

    public EventResponseEnum getEventResponse() {
        if (this.eventResponseEnum == null) {
            this.eventResponseEnum = EventResponseEnum.fromValue(this.eventResponse);
        }
        return this.eventResponseEnum;
    }

    public String getEventResponseString() {
        return this.eventResponse;
    }

    public void setEventResponse(@Nullable EventResponseEnum eventResponse) {
        this.eventResponseEnum = eventResponse;
    }

    public void setEventResponseString(@Nullable String eventResponse) {
        this.eventResponse = eventResponse;
    }

    public CharacterCalendarResponse importance(@Nullable Integer importance) {
        this.importance = importance;
        return this;
    }

    @Nullable
    public Integer getImportance() {
        return this.importance;
    }

    public void setImportance(@Nullable Integer importance) {
        this.importance = importance;
    }

    public CharacterCalendarResponse title(@Nullable String title) {
        this.title = title;
        return this;
    }

    @Nullable
    public String getTitle() {
        return this.title;
    }

    public void setTitle(@Nullable String title) {
        this.title = title;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterCalendarResponse characterCalendarResponse = (CharacterCalendarResponse)o;
        return Objects.equals(this.eventDate, characterCalendarResponse.eventDate) && Objects.equals(this.eventId, characterCalendarResponse.eventId) && Objects.equals(this.eventResponse, characterCalendarResponse.eventResponse) && Objects.equals(this.importance, characterCalendarResponse.importance) && Objects.equals(this.title, characterCalendarResponse.title);
    }

    public int hashCode() {
        return Objects.hash(this.eventDate, this.eventId, this.eventResponse, this.importance, this.title);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterCalendarResponse {\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    eventId: ").append(this.toIndentedString(this.eventId)).append("\n");
        sb.append("    eventResponse: ").append(this.toIndentedString(this.eventResponse)).append("\n");
        sb.append("    importance: ").append(this.toIndentedString(this.importance)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CharacterCalendarResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CharacterCalendarResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `event_response` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE) != null && !jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE).isJsonNull()) {
            EventResponseEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_EVENT_RESPONSE));
        }
        if (jsonObj.get(SERIALIZED_NAME_TITLE) != null && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_TITLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `title` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TITLE).toString()));
        }
    }

    public static CharacterCalendarResponse fromJson(String jsonString) throws IOException {
        return (CharacterCalendarResponse)JSON.getGson().fromJson(jsonString, CharacterCalendarResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_EVENT_DATE);
        openapiFields.add(SERIALIZED_NAME_EVENT_ID);
        openapiFields.add(SERIALIZED_NAME_EVENT_RESPONSE);
        openapiFields.add(SERIALIZED_NAME_IMPORTANCE);
        openapiFields.add(SERIALIZED_NAME_TITLE);
        openapiRequiredFields = new HashSet();
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CharacterCalendarResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CharacterCalendarResponse.class));
            return new TypeAdapter<CharacterCalendarResponse>(){

                public void write(JsonWriter out, CharacterCalendarResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CharacterCalendarResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CharacterCalendarResponse.validateJsonElement(jsonElement);
                    return (CharacterCalendarResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum EventResponseEnum {
        DECLINED("declined"),
        NOT_RESPONDED("not_responded"),
        ACCEPTED("accepted"),
        TENTATIVE("tentative");

        private String value;

        private EventResponseEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventResponseEnum fromValue(String value) {
            for (EventResponseEnum b : EventResponseEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            EventResponseEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<EventResponseEnum> {
            public void write(JsonWriter jsonWriter, EventResponseEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public EventResponseEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return EventResponseEnum.fromValue(value);
            }
        }
    }
}

