/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class CharacterFleetResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_FLEET_BOSS_ID = "fleet_boss_id";
    @SerializedName(value="fleet_boss_id")
    @Nonnull
    private Long fleetBossId;
    public static final String SERIALIZED_NAME_FLEET_ID = "fleet_id";
    @SerializedName(value="fleet_id")
    @Nonnull
    private Long fleetId;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    @Nonnull
    private String role;
    private RoleEnum roleEnum;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    @Nonnull
    private Long squadId;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    @Nonnull
    private Long wingId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CharacterFleetResponse fleetBossId(@Nonnull Long fleetBossId) {
        this.fleetBossId = fleetBossId;
        return this;
    }

    @Nonnull
    public Long getFleetBossId() {
        return this.fleetBossId;
    }

    public void setFleetBossId(@Nonnull Long fleetBossId) {
        this.fleetBossId = fleetBossId;
    }

    public CharacterFleetResponse fleetId(@Nonnull Long fleetId) {
        this.fleetId = fleetId;
        return this;
    }

    @Nonnull
    public Long getFleetId() {
        return this.fleetId;
    }

    public void setFleetId(@Nonnull Long fleetId) {
        this.fleetId = fleetId;
    }

    public CharacterFleetResponse role(@Nonnull RoleEnum role) {
        this.roleEnum = role;
        return this;
    }

    public CharacterFleetResponse roleString(@Nonnull String role) {
        this.role = role;
        return this;
    }

    public RoleEnum getRole() {
        if (this.roleEnum == null) {
            this.roleEnum = RoleEnum.fromValue(this.role);
        }
        return this.roleEnum;
    }

    public String getRoleString() {
        return this.role;
    }

    public void setRole(@Nonnull RoleEnum role) {
        this.roleEnum = role;
    }

    public void setRoleString(@Nonnull String role) {
        this.role = role;
    }

    public CharacterFleetResponse squadId(@Nonnull Long squadId) {
        this.squadId = squadId;
        return this;
    }

    @Nonnull
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(@Nonnull Long squadId) {
        this.squadId = squadId;
    }

    public CharacterFleetResponse wingId(@Nonnull Long wingId) {
        this.wingId = wingId;
        return this;
    }

    @Nonnull
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(@Nonnull Long wingId) {
        this.wingId = wingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterFleetResponse characterFleetResponse = (CharacterFleetResponse)o;
        return Objects.equals(this.fleetBossId, characterFleetResponse.fleetBossId) && Objects.equals(this.fleetId, characterFleetResponse.fleetId) && Objects.equals(this.role, characterFleetResponse.role) && Objects.equals(this.squadId, characterFleetResponse.squadId) && Objects.equals(this.wingId, characterFleetResponse.wingId);
    }

    public int hashCode() {
        return Objects.hash(this.fleetBossId, this.fleetId, this.role, this.squadId, this.wingId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterFleetResponse {\n");
        sb.append("    fleetBossId: ").append(this.toIndentedString(this.fleetBossId)).append("\n");
        sb.append("    fleetId: ").append(this.toIndentedString(this.fleetId)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        sb.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CharacterFleetResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CharacterFleetResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        RoleEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROLE));
    }

    public static CharacterFleetResponse fromJson(String jsonString) throws IOException {
        return (CharacterFleetResponse)JSON.getGson().fromJson(jsonString, CharacterFleetResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_FLEET_BOSS_ID);
        openapiFields.add(SERIALIZED_NAME_FLEET_ID);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_SQUAD_ID);
        openapiFields.add(SERIALIZED_NAME_WING_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_FLEET_BOSS_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FLEET_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE);
        openapiRequiredFields.add(SERIALIZED_NAME_SQUAD_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_WING_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CharacterFleetResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CharacterFleetResponse.class));
            return new TypeAdapter<CharacterFleetResponse>(){

                public void write(JsonWriter out, CharacterFleetResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CharacterFleetResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CharacterFleetResponse.validateJsonElement(jsonElement);
                    return (CharacterFleetResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member"),
        WING_COMMANDER("wing_commander");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            RoleEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

