/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import net.troja.eve.esi.model.EsiVerifyResponse;

public class CharacterInfo {
    private final EsiVerifyResponse response;
    private OffsetDateTime expiresDate;
    private Set<String> scopesSet = null;

    public CharacterInfo(EsiVerifyResponse response) {
        this.response = response;
    }

    public Set<String> getScopes() {
        if (this.scopesSet == null) {
            this.scopesSet = this.response.getScopes() != null ? new HashSet<String>(Arrays.asList(this.response.getScopes().split(" "))) : new HashSet<String>();
        }
        return this.scopesSet;
    }

    public String toString() {
        return this.response.toString();
    }

    public int hashCode() {
        return this.response.hashCode();
    }

    public boolean equals(Object o) {
        return this.response.equals(o);
    }

    public void setCharacterOwnerHash(String characterOwnerHash) {
        this.response.setCharacterOwnerHash(characterOwnerHash);
    }

    public String getCharacterOwnerHash() {
        return this.response.getCharacterOwnerHash();
    }

    public EsiVerifyResponse characterOwnerHash(String characterOwnerHash) {
        return this.response.characterOwnerHash(characterOwnerHash);
    }

    public void setExpiresOn(String expiresOn) {
        this.response.setExpiresOn(expiresOn);
    }

    public OffsetDateTime getExpiresOn() {
        if (this.expiresDate == null) {
            this.expiresDate = OffsetDateTime.of(LocalDateTime.parse(this.response.getExpiresOn()), ZoneOffset.UTC);
        }
        return this.expiresDate;
    }

    public EsiVerifyResponse expiresOn(String expiresOn) {
        return this.response.expiresOn(expiresOn);
    }

    public void setCharacterName(String characterName) {
        this.response.setCharacterName(characterName);
    }

    public String getCharacterName() {
        return this.response.getCharacterName();
    }

    public EsiVerifyResponse characterName(String characterName) {
        return this.response.characterName(characterName);
    }

    public void setCharacterID(Integer characterID) {
        this.response.setCharacterID(characterID);
    }

    public Integer getCharacterID() {
        return this.response.getCharacterID();
    }

    public EsiVerifyResponse characterID(Integer characterID) {
        return this.response.characterID(characterID);
    }

    public void setScopes(String scopes) {
        this.response.setScopes(scopes);
    }

    public EsiVerifyResponse scopes(String scopes) {
        return this.response.scopes(scopes);
    }

    public void setIntellectualProperty(String intellectualProperty) {
        this.response.setIntellectualProperty(intellectualProperty);
    }

    public String getIntellectualProperty() {
        return this.response.getIntellectualProperty();
    }

    public EsiVerifyResponse intellectualProperty(String intellectualProperty) {
        return this.response.intellectualProperty(intellectualProperty);
    }

    public void setTokenType(String tokenType) {
        this.response.setTokenType(tokenType);
    }

    public String getTokenType() {
        return this.response.getTokenType();
    }

    public EsiVerifyResponse tokenType(String tokenType) {
        return this.response.tokenType(tokenType);
    }
}

