/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class CharacterPlanetsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_LAST_UPDATE = "last_update";
    @SerializedName(value="last_update")
    @Nonnull
    private OffsetDateTime lastUpdate;
    public static final String SERIALIZED_NAME_NUM_PINS = "num_pins";
    @SerializedName(value="num_pins")
    @Nonnull
    private Integer numPins;
    public static final String SERIALIZED_NAME_OWNER_ID = "owner_id";
    @SerializedName(value="owner_id")
    @Nonnull
    private Integer ownerId;
    public static final String SERIALIZED_NAME_PLANET_ID = "planet_id";
    @SerializedName(value="planet_id")
    @Nonnull
    private Integer planetId;
    public static final String SERIALIZED_NAME_PLANET_TYPE = "planet_type";
    @SerializedName(value="planet_type")
    @Nonnull
    private String planetType;
    private PlanetTypeEnum planetTypeEnum;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    @Nonnull
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_UPGRADE_LEVEL = "upgrade_level";
    @SerializedName(value="upgrade_level")
    @Nonnull
    private Integer upgradeLevel;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public CharacterPlanetsResponse lastUpdate(@Nonnull OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
        return this;
    }

    @Nonnull
    public OffsetDateTime getLastUpdate() {
        return this.lastUpdate;
    }

    public void setLastUpdate(@Nonnull OffsetDateTime lastUpdate) {
        this.lastUpdate = lastUpdate;
    }

    public CharacterPlanetsResponse numPins(@Nonnull Integer numPins) {
        this.numPins = numPins;
        return this;
    }

    @Nonnull
    public Integer getNumPins() {
        return this.numPins;
    }

    public void setNumPins(@Nonnull Integer numPins) {
        this.numPins = numPins;
    }

    public CharacterPlanetsResponse ownerId(@Nonnull Integer ownerId) {
        this.ownerId = ownerId;
        return this;
    }

    @Nonnull
    public Integer getOwnerId() {
        return this.ownerId;
    }

    public void setOwnerId(@Nonnull Integer ownerId) {
        this.ownerId = ownerId;
    }

    public CharacterPlanetsResponse planetId(@Nonnull Integer planetId) {
        this.planetId = planetId;
        return this;
    }

    @Nonnull
    public Integer getPlanetId() {
        return this.planetId;
    }

    public void setPlanetId(@Nonnull Integer planetId) {
        this.planetId = planetId;
    }

    public CharacterPlanetsResponse planetType(@Nonnull PlanetTypeEnum planetType) {
        this.planetTypeEnum = planetType;
        return this;
    }

    public CharacterPlanetsResponse planetTypeString(@Nonnull String planetType) {
        this.planetType = planetType;
        return this;
    }

    public PlanetTypeEnum getPlanetType() {
        if (this.planetTypeEnum == null) {
            this.planetTypeEnum = PlanetTypeEnum.fromValue(this.planetType);
        }
        return this.planetTypeEnum;
    }

    public String getPlanetTypeString() {
        return this.planetType;
    }

    public void setPlanetType(@Nonnull PlanetTypeEnum planetType) {
        this.planetTypeEnum = planetType;
    }

    public void setPlanetTypeString(@Nonnull String planetType) {
        this.planetType = planetType;
    }

    public CharacterPlanetsResponse solarSystemId(@Nonnull Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    @Nonnull
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(@Nonnull Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public CharacterPlanetsResponse upgradeLevel(@Nonnull Integer upgradeLevel) {
        this.upgradeLevel = upgradeLevel;
        return this;
    }

    @Nonnull
    public Integer getUpgradeLevel() {
        return this.upgradeLevel;
    }

    public void setUpgradeLevel(@Nonnull Integer upgradeLevel) {
        this.upgradeLevel = upgradeLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CharacterPlanetsResponse characterPlanetsResponse = (CharacterPlanetsResponse)o;
        return Objects.equals(this.lastUpdate, characterPlanetsResponse.lastUpdate) && Objects.equals(this.numPins, characterPlanetsResponse.numPins) && Objects.equals(this.ownerId, characterPlanetsResponse.ownerId) && Objects.equals(this.planetId, characterPlanetsResponse.planetId) && Objects.equals(this.planetType, characterPlanetsResponse.planetType) && Objects.equals(this.solarSystemId, characterPlanetsResponse.solarSystemId) && Objects.equals(this.upgradeLevel, characterPlanetsResponse.upgradeLevel);
    }

    public int hashCode() {
        return Objects.hash(this.lastUpdate, this.numPins, this.ownerId, this.planetId, this.planetType, this.solarSystemId, this.upgradeLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CharacterPlanetsResponse {\n");
        sb.append("    lastUpdate: ").append(this.toIndentedString(this.lastUpdate)).append("\n");
        sb.append("    numPins: ").append(this.toIndentedString(this.numPins)).append("\n");
        sb.append("    ownerId: ").append(this.toIndentedString(this.ownerId)).append("\n");
        sb.append("    planetId: ").append(this.toIndentedString(this.planetId)).append("\n");
        sb.append("    planetType: ").append(this.toIndentedString(this.planetType)).append("\n");
        sb.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        sb.append("    upgradeLevel: ").append(this.toIndentedString(this.upgradeLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in CharacterPlanetsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `CharacterPlanetsResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_PLANET_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `planet_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLANET_TYPE).toString()));
        }
        PlanetTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_PLANET_TYPE));
    }

    public static CharacterPlanetsResponse fromJson(String jsonString) throws IOException {
        return (CharacterPlanetsResponse)JSON.getGson().fromJson(jsonString, CharacterPlanetsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_LAST_UPDATE);
        openapiFields.add(SERIALIZED_NAME_NUM_PINS);
        openapiFields.add(SERIALIZED_NAME_OWNER_ID);
        openapiFields.add(SERIALIZED_NAME_PLANET_ID);
        openapiFields.add(SERIALIZED_NAME_PLANET_TYPE);
        openapiFields.add(SERIALIZED_NAME_SOLAR_SYSTEM_ID);
        openapiFields.add(SERIALIZED_NAME_UPGRADE_LEVEL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_LAST_UPDATE);
        openapiRequiredFields.add(SERIALIZED_NAME_NUM_PINS);
        openapiRequiredFields.add(SERIALIZED_NAME_OWNER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PLANET_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PLANET_TYPE);
        openapiRequiredFields.add(SERIALIZED_NAME_SOLAR_SYSTEM_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_UPGRADE_LEVEL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!CharacterPlanetsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(CharacterPlanetsResponse.class));
            return new TypeAdapter<CharacterPlanetsResponse>(){

                public void write(JsonWriter out, CharacterPlanetsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public CharacterPlanetsResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    CharacterPlanetsResponse.validateJsonElement(jsonElement);
                    return (CharacterPlanetsResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum PlanetTypeEnum {
        TEMPERATE("temperate"),
        BARREN("barren"),
        OCEANIC("oceanic"),
        ICE("ice"),
        GAS("gas"),
        LAVA("lava"),
        STORM("storm"),
        PLASMA("plasma");

        private String value;

        private PlanetTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static PlanetTypeEnum fromValue(String value) {
            for (PlanetTypeEnum b : PlanetTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            PlanetTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<PlanetTypeEnum> {
            public void write(JsonWriter jsonWriter, PlanetTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public PlanetTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return PlanetTypeEnum.fromValue(value);
            }
        }
    }
}

