/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.troja.eve.esi.JSON;

public class Clone
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_IMPLANTS = "implants";
    @SerializedName(value="implants")
    @Nonnull
    private List<Integer> implants;
    public static final String SERIALIZED_NAME_JUMP_CLONE_ID = "jump_clone_id";
    @SerializedName(value="jump_clone_id")
    @Nonnull
    private Integer jumpCloneId;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    @Nonnull
    private Long locationId;
    public static final String SERIALIZED_NAME_LOCATION_TYPE = "location_type";
    @SerializedName(value="location_type")
    @Nonnull
    private String locationType;
    private LocationTypeEnum locationTypeEnum;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nullable
    private String name;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Clone implants(@Nonnull List<Integer> implants) {
        this.implants = implants;
        return this;
    }

    public Clone addImplantsItem(Integer implantsItem) {
        if (this.implants == null) {
            this.implants = new ArrayList<Integer>();
        }
        this.implants.add(implantsItem);
        return this;
    }

    @Nonnull
    public List<Integer> getImplants() {
        return this.implants;
    }

    public void setImplants(@Nonnull List<Integer> implants) {
        this.implants = implants;
    }

    public Clone jumpCloneId(@Nonnull Integer jumpCloneId) {
        this.jumpCloneId = jumpCloneId;
        return this;
    }

    @Nonnull
    public Integer getJumpCloneId() {
        return this.jumpCloneId;
    }

    public void setJumpCloneId(@Nonnull Integer jumpCloneId) {
        this.jumpCloneId = jumpCloneId;
    }

    public Clone locationId(@Nonnull Long locationId) {
        this.locationId = locationId;
        return this;
    }

    @Nonnull
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(@Nonnull Long locationId) {
        this.locationId = locationId;
    }

    public Clone locationType(@Nonnull LocationTypeEnum locationType) {
        this.locationTypeEnum = locationType;
        return this;
    }

    public Clone locationTypeString(@Nonnull String locationType) {
        this.locationType = locationType;
        return this;
    }

    public LocationTypeEnum getLocationType() {
        if (this.locationTypeEnum == null) {
            this.locationTypeEnum = LocationTypeEnum.fromValue(this.locationType);
        }
        return this.locationTypeEnum;
    }

    public String getLocationTypeString() {
        return this.locationType;
    }

    public void setLocationType(@Nonnull LocationTypeEnum locationType) {
        this.locationTypeEnum = locationType;
    }

    public void setLocationTypeString(@Nonnull String locationType) {
        this.locationType = locationType;
    }

    public Clone name(@Nullable String name) {
        this.name = name;
        return this;
    }

    @Nullable
    public String getName() {
        return this.name;
    }

    public void setName(@Nullable String name) {
        this.name = name;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Clone clone = (Clone)o;
        return Objects.equals(this.implants, clone.implants) && Objects.equals(this.jumpCloneId, clone.jumpCloneId) && Objects.equals(this.locationId, clone.locationId) && Objects.equals(this.locationType, clone.locationType) && Objects.equals(this.name, clone.name);
    }

    public int hashCode() {
        return Objects.hash(this.implants, this.jumpCloneId, this.locationId, this.locationType, this.name);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Clone {\n");
        sb.append("    implants: ").append(this.toIndentedString(this.implants)).append("\n");
        sb.append("    jumpCloneId: ").append(this.toIndentedString(this.jumpCloneId)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    locationType: ").append(this.toIndentedString(this.locationType)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Clone is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Clone` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_IMPLANTS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_IMPLANTS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `implants` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_IMPLANTS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_LOCATION_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `location_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_LOCATION_TYPE).toString()));
        }
        LocationTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_LOCATION_TYPE));
        if (jsonObj.get(SERIALIZED_NAME_NAME) != null && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
    }

    public static Clone fromJson(String jsonString) throws IOException {
        return (Clone)JSON.getGson().fromJson(jsonString, Clone.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_IMPLANTS);
        openapiFields.add(SERIALIZED_NAME_JUMP_CLONE_ID);
        openapiFields.add(SERIALIZED_NAME_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_LOCATION_TYPE);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_IMPLANTS);
        openapiRequiredFields.add(SERIALIZED_NAME_JUMP_CLONE_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_LOCATION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_LOCATION_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Clone.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Clone.class));
            return new TypeAdapter<Clone>(){

                public void write(JsonWriter out, Clone value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Clone read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Clone.validateJsonElement(jsonElement);
                    return (Clone)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum LocationTypeEnum {
        STATION("station"),
        STRUCTURE("structure");

        private String value;

        private LocationTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static LocationTypeEnum fromValue(String value) {
            for (LocationTypeEnum b : LocationTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            LocationTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<LocationTypeEnum> {
            public void write(JsonWriter jsonWriter, LocationTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public LocationTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return LocationTypeEnum.fromValue(value);
            }
        }
    }
}

