/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class EsiStatusResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ENDPOINT = "endpoint";
    @SerializedName(value="endpoint")
    @Nonnull
    private String endpoint;
    public static final String SERIALIZED_NAME_METHOD = "method";
    @SerializedName(value="method")
    @Nonnull
    private String method;
    public static final String SERIALIZED_NAME_ROUTE = "route";
    @SerializedName(value="route")
    @Nonnull
    private String route;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    @Nonnull
    private String status;
    private StatusEnum statusEnum;
    public static final String SERIALIZED_NAME_TAGS = "tags";
    @SerializedName(value="tags")
    @Nonnull
    private List<String> tags;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public EsiStatusResponse endpoint(@Nonnull String endpoint) {
        this.endpoint = endpoint;
        return this;
    }

    @Nonnull
    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(@Nonnull String endpoint) {
        this.endpoint = endpoint;
    }

    public EsiStatusResponse method(@Nonnull String method) {
        this.method = method;
        return this;
    }

    @Nonnull
    public String getMethod() {
        return this.method;
    }

    public void setMethod(@Nonnull String method) {
        this.method = method;
    }

    public EsiStatusResponse route(@Nonnull String route) {
        this.route = route;
        return this;
    }

    @Nonnull
    public String getRoute() {
        return this.route;
    }

    public void setRoute(@Nonnull String route) {
        this.route = route;
    }

    public EsiStatusResponse status(@Nonnull StatusEnum status) {
        this.statusEnum = status;
        return this;
    }

    public EsiStatusResponse statusString(@Nonnull String status) {
        this.status = status;
        return this;
    }

    public StatusEnum getStatus() {
        if (this.statusEnum == null) {
            this.statusEnum = StatusEnum.fromValue(this.status);
        }
        return this.statusEnum;
    }

    public String getStatusString() {
        return this.status;
    }

    public void setStatus(@Nonnull StatusEnum status) {
        this.statusEnum = status;
    }

    public void setStatusString(@Nonnull String status) {
        this.status = status;
    }

    public EsiStatusResponse tags(@Nonnull List<String> tags) {
        this.tags = tags;
        return this;
    }

    public EsiStatusResponse addTagsItem(String tagsItem) {
        if (this.tags == null) {
            this.tags = new ArrayList<String>();
        }
        this.tags.add(tagsItem);
        return this;
    }

    @Nonnull
    public List<String> getTags() {
        return this.tags;
    }

    public void setTags(@Nonnull List<String> tags) {
        this.tags = tags;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EsiStatusResponse esiStatusResponse = (EsiStatusResponse)o;
        return Objects.equals(this.endpoint, esiStatusResponse.endpoint) && Objects.equals(this.method, esiStatusResponse.method) && Objects.equals(this.route, esiStatusResponse.route) && Objects.equals(this.status, esiStatusResponse.status) && Objects.equals(this.tags, esiStatusResponse.tags);
    }

    public int hashCode() {
        return Objects.hash(this.endpoint, this.method, this.route, this.status, this.tags);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class EsiStatusResponse {\n");
        sb.append("    endpoint: ").append(this.toIndentedString(this.endpoint)).append("\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    route: ").append(this.toIndentedString(this.route)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    tags: ").append(this.toIndentedString(this.tags)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in EsiStatusResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `EsiStatusResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ENDPOINT).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `endpoint` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ENDPOINT).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_METHOD).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `method` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_METHOD).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_ROUTE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `route` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROUTE).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATUS).toString()));
        }
        StatusEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
        if (jsonObj.get(SERIALIZED_NAME_TAGS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_TAGS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `tags` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TAGS).toString()));
        }
    }

    public static EsiStatusResponse fromJson(String jsonString) throws IOException {
        return (EsiStatusResponse)JSON.getGson().fromJson(jsonString, EsiStatusResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ENDPOINT);
        openapiFields.add(SERIALIZED_NAME_METHOD);
        openapiFields.add(SERIALIZED_NAME_ROUTE);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiFields.add(SERIALIZED_NAME_TAGS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ENDPOINT);
        openapiRequiredFields.add(SERIALIZED_NAME_METHOD);
        openapiRequiredFields.add(SERIALIZED_NAME_ROUTE);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_TAGS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!EsiStatusResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(EsiStatusResponse.class));
            return new TypeAdapter<EsiStatusResponse>(){

                public void write(JsonWriter out, EsiStatusResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public EsiStatusResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    EsiStatusResponse.validateJsonElement(jsonElement);
                    return (EsiStatusResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        GREEN("green"),
        YELLOW("yellow"),
        RED("red");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String value) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StatusEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

