/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.troja.eve.esi.JSON;

public class FleetMembersResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CHARACTER_ID = "character_id";
    @SerializedName(value="character_id")
    @Nonnull
    private Integer characterId;
    public static final String SERIALIZED_NAME_JOIN_TIME = "join_time";
    @SerializedName(value="join_time")
    @Nonnull
    private OffsetDateTime joinTime;
    public static final String SERIALIZED_NAME_ROLE = "role";
    @SerializedName(value="role")
    @Nonnull
    private String role;
    private RoleEnum roleEnum;
    public static final String SERIALIZED_NAME_ROLE_NAME = "role_name";
    @SerializedName(value="role_name")
    @Nonnull
    private String roleName;
    public static final String SERIALIZED_NAME_SHIP_TYPE_ID = "ship_type_id";
    @SerializedName(value="ship_type_id")
    @Nonnull
    private Integer shipTypeId;
    public static final String SERIALIZED_NAME_SOLAR_SYSTEM_ID = "solar_system_id";
    @SerializedName(value="solar_system_id")
    @Nonnull
    private Integer solarSystemId;
    public static final String SERIALIZED_NAME_SQUAD_ID = "squad_id";
    @SerializedName(value="squad_id")
    @Nonnull
    private Long squadId;
    public static final String SERIALIZED_NAME_STATION_ID = "station_id";
    @SerializedName(value="station_id")
    @Nullable
    private Long stationId;
    public static final String SERIALIZED_NAME_TAKES_FLEET_WARP = "takes_fleet_warp";
    @SerializedName(value="takes_fleet_warp")
    @Nonnull
    private Boolean takesFleetWarp;
    public static final String SERIALIZED_NAME_WING_ID = "wing_id";
    @SerializedName(value="wing_id")
    @Nonnull
    private Long wingId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public FleetMembersResponse characterId(@Nonnull Integer characterId) {
        this.characterId = characterId;
        return this;
    }

    @Nonnull
    public Integer getCharacterId() {
        return this.characterId;
    }

    public void setCharacterId(@Nonnull Integer characterId) {
        this.characterId = characterId;
    }

    public FleetMembersResponse joinTime(@Nonnull OffsetDateTime joinTime) {
        this.joinTime = joinTime;
        return this;
    }

    @Nonnull
    public OffsetDateTime getJoinTime() {
        return this.joinTime;
    }

    public void setJoinTime(@Nonnull OffsetDateTime joinTime) {
        this.joinTime = joinTime;
    }

    public FleetMembersResponse role(@Nonnull RoleEnum role) {
        this.roleEnum = role;
        return this;
    }

    public FleetMembersResponse roleString(@Nonnull String role) {
        this.role = role;
        return this;
    }

    public RoleEnum getRole() {
        if (this.roleEnum == null) {
            this.roleEnum = RoleEnum.fromValue(this.role);
        }
        return this.roleEnum;
    }

    public String getRoleString() {
        return this.role;
    }

    public void setRole(@Nonnull RoleEnum role) {
        this.roleEnum = role;
    }

    public void setRoleString(@Nonnull String role) {
        this.role = role;
    }

    public FleetMembersResponse roleName(@Nonnull String roleName) {
        this.roleName = roleName;
        return this;
    }

    @Nonnull
    public String getRoleName() {
        return this.roleName;
    }

    public void setRoleName(@Nonnull String roleName) {
        this.roleName = roleName;
    }

    public FleetMembersResponse shipTypeId(@Nonnull Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
        return this;
    }

    @Nonnull
    public Integer getShipTypeId() {
        return this.shipTypeId;
    }

    public void setShipTypeId(@Nonnull Integer shipTypeId) {
        this.shipTypeId = shipTypeId;
    }

    public FleetMembersResponse solarSystemId(@Nonnull Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
        return this;
    }

    @Nonnull
    public Integer getSolarSystemId() {
        return this.solarSystemId;
    }

    public void setSolarSystemId(@Nonnull Integer solarSystemId) {
        this.solarSystemId = solarSystemId;
    }

    public FleetMembersResponse squadId(@Nonnull Long squadId) {
        this.squadId = squadId;
        return this;
    }

    @Nonnull
    public Long getSquadId() {
        return this.squadId;
    }

    public void setSquadId(@Nonnull Long squadId) {
        this.squadId = squadId;
    }

    public FleetMembersResponse stationId(@Nullable Long stationId) {
        this.stationId = stationId;
        return this;
    }

    @Nullable
    public Long getStationId() {
        return this.stationId;
    }

    public void setStationId(@Nullable Long stationId) {
        this.stationId = stationId;
    }

    public FleetMembersResponse takesFleetWarp(@Nonnull Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
        return this;
    }

    @Nonnull
    public Boolean getTakesFleetWarp() {
        return this.takesFleetWarp;
    }

    public void setTakesFleetWarp(@Nonnull Boolean takesFleetWarp) {
        this.takesFleetWarp = takesFleetWarp;
    }

    public FleetMembersResponse wingId(@Nonnull Long wingId) {
        this.wingId = wingId;
        return this;
    }

    @Nonnull
    public Long getWingId() {
        return this.wingId;
    }

    public void setWingId(@Nonnull Long wingId) {
        this.wingId = wingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FleetMembersResponse fleetMembersResponse = (FleetMembersResponse)o;
        return Objects.equals(this.characterId, fleetMembersResponse.characterId) && Objects.equals(this.joinTime, fleetMembersResponse.joinTime) && Objects.equals(this.role, fleetMembersResponse.role) && Objects.equals(this.roleName, fleetMembersResponse.roleName) && Objects.equals(this.shipTypeId, fleetMembersResponse.shipTypeId) && Objects.equals(this.solarSystemId, fleetMembersResponse.solarSystemId) && Objects.equals(this.squadId, fleetMembersResponse.squadId) && Objects.equals(this.stationId, fleetMembersResponse.stationId) && Objects.equals(this.takesFleetWarp, fleetMembersResponse.takesFleetWarp) && Objects.equals(this.wingId, fleetMembersResponse.wingId);
    }

    public int hashCode() {
        return Objects.hash(this.characterId, this.joinTime, this.role, this.roleName, this.shipTypeId, this.solarSystemId, this.squadId, this.stationId, this.takesFleetWarp, this.wingId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FleetMembersResponse {\n");
        sb.append("    characterId: ").append(this.toIndentedString(this.characterId)).append("\n");
        sb.append("    joinTime: ").append(this.toIndentedString(this.joinTime)).append("\n");
        sb.append("    role: ").append(this.toIndentedString(this.role)).append("\n");
        sb.append("    roleName: ").append(this.toIndentedString(this.roleName)).append("\n");
        sb.append("    shipTypeId: ").append(this.toIndentedString(this.shipTypeId)).append("\n");
        sb.append("    solarSystemId: ").append(this.toIndentedString(this.solarSystemId)).append("\n");
        sb.append("    squadId: ").append(this.toIndentedString(this.squadId)).append("\n");
        sb.append("    stationId: ").append(this.toIndentedString(this.stationId)).append("\n");
        sb.append("    takesFleetWarp: ").append(this.toIndentedString(this.takesFleetWarp)).append("\n");
        sb.append("    wingId: ").append(this.toIndentedString(this.wingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in FleetMembersResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `FleetMembersResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ROLE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE).toString()));
        }
        RoleEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ROLE));
        if (!jsonObj.get(SERIALIZED_NAME_ROLE_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `role_name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ROLE_NAME).toString()));
        }
    }

    public static FleetMembersResponse fromJson(String jsonString) throws IOException {
        return (FleetMembersResponse)JSON.getGson().fromJson(jsonString, FleetMembersResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CHARACTER_ID);
        openapiFields.add(SERIALIZED_NAME_JOIN_TIME);
        openapiFields.add(SERIALIZED_NAME_ROLE);
        openapiFields.add(SERIALIZED_NAME_ROLE_NAME);
        openapiFields.add(SERIALIZED_NAME_SHIP_TYPE_ID);
        openapiFields.add(SERIALIZED_NAME_SOLAR_SYSTEM_ID);
        openapiFields.add(SERIALIZED_NAME_SQUAD_ID);
        openapiFields.add(SERIALIZED_NAME_STATION_ID);
        openapiFields.add(SERIALIZED_NAME_TAKES_FLEET_WARP);
        openapiFields.add(SERIALIZED_NAME_WING_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CHARACTER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_JOIN_TIME);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE);
        openapiRequiredFields.add(SERIALIZED_NAME_ROLE_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_SHIP_TYPE_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SOLAR_SYSTEM_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_SQUAD_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_TAKES_FLEET_WARP);
        openapiRequiredFields.add(SERIALIZED_NAME_WING_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!FleetMembersResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(FleetMembersResponse.class));
            return new TypeAdapter<FleetMembersResponse>(){

                public void write(JsonWriter out, FleetMembersResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public FleetMembersResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    FleetMembersResponse.validateJsonElement(jsonElement);
                    return (FleetMembersResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RoleEnum {
        FLEET_COMMANDER("fleet_commander"),
        WING_COMMANDER("wing_commander"),
        SQUAD_COMMANDER("squad_commander"),
        SQUAD_MEMBER("squad_member");

        private String value;

        private RoleEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RoleEnum fromValue(String value) {
            for (RoleEnum b : RoleEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            RoleEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<RoleEnum> {
            public void write(JsonWriter jsonWriter, RoleEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RoleEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RoleEnum.fromValue(value);
            }
        }
    }
}

