/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class IncursionsResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    @Nonnull
    private Integer constellationId;
    public static final String SERIALIZED_NAME_FACTION_ID = "faction_id";
    @SerializedName(value="faction_id")
    @Nonnull
    private Integer factionId;
    public static final String SERIALIZED_NAME_HAS_BOSS = "has_boss";
    @SerializedName(value="has_boss")
    @Nonnull
    private Boolean hasBoss;
    public static final String SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS = "infested_solar_systems";
    @SerializedName(value="infested_solar_systems")
    @Nonnull
    private List<Integer> infestedSolarSystems;
    public static final String SERIALIZED_NAME_INFLUENCE = "influence";
    @SerializedName(value="influence")
    @Nonnull
    private Float influence;
    public static final String SERIALIZED_NAME_STAGING_SOLAR_SYSTEM_ID = "staging_solar_system_id";
    @SerializedName(value="staging_solar_system_id")
    @Nonnull
    private Integer stagingSolarSystemId;
    public static final String SERIALIZED_NAME_STATE = "state";
    @SerializedName(value="state")
    @Nonnull
    private String state;
    private StateEnum stateEnum;
    public static final String SERIALIZED_NAME_TYPE = "type";
    @SerializedName(value="type")
    @Nonnull
    private String type;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IncursionsResponse constellationId(@Nonnull Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    @Nonnull
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(@Nonnull Integer constellationId) {
        this.constellationId = constellationId;
    }

    public IncursionsResponse factionId(@Nonnull Integer factionId) {
        this.factionId = factionId;
        return this;
    }

    @Nonnull
    public Integer getFactionId() {
        return this.factionId;
    }

    public void setFactionId(@Nonnull Integer factionId) {
        this.factionId = factionId;
    }

    public IncursionsResponse hasBoss(@Nonnull Boolean hasBoss) {
        this.hasBoss = hasBoss;
        return this;
    }

    @Nonnull
    public Boolean getHasBoss() {
        return this.hasBoss;
    }

    public void setHasBoss(@Nonnull Boolean hasBoss) {
        this.hasBoss = hasBoss;
    }

    public IncursionsResponse infestedSolarSystems(@Nonnull List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
        return this;
    }

    public IncursionsResponse addInfestedSolarSystemsItem(Integer infestedSolarSystemsItem) {
        if (this.infestedSolarSystems == null) {
            this.infestedSolarSystems = new ArrayList<Integer>();
        }
        this.infestedSolarSystems.add(infestedSolarSystemsItem);
        return this;
    }

    @Nonnull
    public List<Integer> getInfestedSolarSystems() {
        return this.infestedSolarSystems;
    }

    public void setInfestedSolarSystems(@Nonnull List<Integer> infestedSolarSystems) {
        this.infestedSolarSystems = infestedSolarSystems;
    }

    public IncursionsResponse influence(@Nonnull Float influence) {
        this.influence = influence;
        return this;
    }

    @Nonnull
    public Float getInfluence() {
        return this.influence;
    }

    public void setInfluence(@Nonnull Float influence) {
        this.influence = influence;
    }

    public IncursionsResponse stagingSolarSystemId(@Nonnull Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
        return this;
    }

    @Nonnull
    public Integer getStagingSolarSystemId() {
        return this.stagingSolarSystemId;
    }

    public void setStagingSolarSystemId(@Nonnull Integer stagingSolarSystemId) {
        this.stagingSolarSystemId = stagingSolarSystemId;
    }

    public IncursionsResponse state(@Nonnull StateEnum state) {
        this.stateEnum = state;
        return this;
    }

    public IncursionsResponse stateString(@Nonnull String state) {
        this.state = state;
        return this;
    }

    public StateEnum getState() {
        if (this.stateEnum == null) {
            this.stateEnum = StateEnum.fromValue(this.state);
        }
        return this.stateEnum;
    }

    public String getStateString() {
        return this.state;
    }

    public void setState(@Nonnull StateEnum state) {
        this.stateEnum = state;
    }

    public void setStateString(@Nonnull String state) {
        this.state = state;
    }

    public IncursionsResponse type(@Nonnull String type) {
        this.type = type;
        return this;
    }

    @Nonnull
    public String getType() {
        return this.type;
    }

    public void setType(@Nonnull String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncursionsResponse incursionsResponse = (IncursionsResponse)o;
        return Objects.equals(this.constellationId, incursionsResponse.constellationId) && Objects.equals(this.factionId, incursionsResponse.factionId) && Objects.equals(this.hasBoss, incursionsResponse.hasBoss) && Objects.equals(this.infestedSolarSystems, incursionsResponse.infestedSolarSystems) && Objects.equals(this.influence, incursionsResponse.influence) && Objects.equals(this.stagingSolarSystemId, incursionsResponse.stagingSolarSystemId) && Objects.equals(this.state, incursionsResponse.state) && Objects.equals(this.type, incursionsResponse.type);
    }

    public int hashCode() {
        return Objects.hash(this.constellationId, this.factionId, this.hasBoss, this.infestedSolarSystems, this.influence, this.stagingSolarSystemId, this.state, this.type);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IncursionsResponse {\n");
        sb.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        sb.append("    factionId: ").append(this.toIndentedString(this.factionId)).append("\n");
        sb.append("    hasBoss: ").append(this.toIndentedString(this.hasBoss)).append("\n");
        sb.append("    infestedSolarSystems: ").append(this.toIndentedString(this.infestedSolarSystems)).append("\n");
        sb.append("    influence: ").append(this.toIndentedString(this.influence)).append("\n");
        sb.append("    stagingSolarSystemId: ").append(this.toIndentedString(this.stagingSolarSystemId)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IncursionsResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IncursionsResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (jsonObj.get(SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS) == null) {
            throw new IllegalArgumentException("Expected the field `linkedContent` to be an array in the JSON string but got `null`");
        }
        if (!jsonObj.get(SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `infested_solar_systems` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS).toString()));
        }
        if (!jsonObj.get(SERIALIZED_NAME_STATE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `state` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATE).toString()));
        }
        StateEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATE));
        if (!jsonObj.get(SERIALIZED_NAME_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_TYPE).toString()));
        }
    }

    public static IncursionsResponse fromJson(String jsonString) throws IOException {
        return (IncursionsResponse)JSON.getGson().fromJson(jsonString, IncursionsResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONSTELLATION_ID);
        openapiFields.add(SERIALIZED_NAME_FACTION_ID);
        openapiFields.add(SERIALIZED_NAME_HAS_BOSS);
        openapiFields.add(SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS);
        openapiFields.add(SERIALIZED_NAME_INFLUENCE);
        openapiFields.add(SERIALIZED_NAME_STAGING_SOLAR_SYSTEM_ID);
        openapiFields.add(SERIALIZED_NAME_STATE);
        openapiFields.add(SERIALIZED_NAME_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONSTELLATION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_FACTION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_HAS_BOSS);
        openapiRequiredFields.add(SERIALIZED_NAME_INFESTED_SOLAR_SYSTEMS);
        openapiRequiredFields.add(SERIALIZED_NAME_INFLUENCE);
        openapiRequiredFields.add(SERIALIZED_NAME_STAGING_SOLAR_SYSTEM_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_STATE);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IncursionsResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IncursionsResponse.class));
            return new TypeAdapter<IncursionsResponse>(){

                public void write(JsonWriter out, IncursionsResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IncursionsResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IncursionsResponse.validateJsonElement(jsonElement);
                    return (IncursionsResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StateEnum {
        WITHDRAWING("withdrawing"),
        MOBILIZING("mobilizing"),
        ESTABLISHED("established");

        private String value;

        private StateEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StateEnum fromValue(String value) {
            for (StateEnum b : StateEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            StateEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<StateEnum> {
            public void write(JsonWriter jsonWriter, StateEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public StateEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StateEnum.fromValue(value);
            }
        }
    }
}

