/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class MarketStructuresResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_DURATION = "duration";
    @SerializedName(value="duration")
    @Nonnull
    private Integer duration;
    public static final String SERIALIZED_NAME_IS_BUY_ORDER = "is_buy_order";
    @SerializedName(value="is_buy_order")
    @Nonnull
    private Boolean isBuyOrder;
    public static final String SERIALIZED_NAME_ISSUED = "issued";
    @SerializedName(value="issued")
    @Nonnull
    private OffsetDateTime issued;
    public static final String SERIALIZED_NAME_LOCATION_ID = "location_id";
    @SerializedName(value="location_id")
    @Nonnull
    private Long locationId;
    public static final String SERIALIZED_NAME_MIN_VOLUME = "min_volume";
    @SerializedName(value="min_volume")
    @Nonnull
    private Integer minVolume;
    public static final String SERIALIZED_NAME_ORDER_ID = "order_id";
    @SerializedName(value="order_id")
    @Nonnull
    private Long orderId;
    public static final String SERIALIZED_NAME_PRICE = "price";
    @SerializedName(value="price")
    @Nonnull
    private Double price;
    public static final String SERIALIZED_NAME_RANGE = "range";
    @SerializedName(value="range")
    @Nonnull
    private String range;
    private RangeEnum rangeEnum;
    public static final String SERIALIZED_NAME_TYPE_ID = "type_id";
    @SerializedName(value="type_id")
    @Nonnull
    private Integer typeId;
    public static final String SERIALIZED_NAME_VOLUME_REMAIN = "volume_remain";
    @SerializedName(value="volume_remain")
    @Nonnull
    private Integer volumeRemain;
    public static final String SERIALIZED_NAME_VOLUME_TOTAL = "volume_total";
    @SerializedName(value="volume_total")
    @Nonnull
    private Integer volumeTotal;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public MarketStructuresResponse duration(@Nonnull Integer duration) {
        this.duration = duration;
        return this;
    }

    @Nonnull
    public Integer getDuration() {
        return this.duration;
    }

    public void setDuration(@Nonnull Integer duration) {
        this.duration = duration;
    }

    public MarketStructuresResponse isBuyOrder(@Nonnull Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
        return this;
    }

    @Nonnull
    public Boolean getIsBuyOrder() {
        return this.isBuyOrder;
    }

    public void setIsBuyOrder(@Nonnull Boolean isBuyOrder) {
        this.isBuyOrder = isBuyOrder;
    }

    public MarketStructuresResponse issued(@Nonnull OffsetDateTime issued) {
        this.issued = issued;
        return this;
    }

    @Nonnull
    public OffsetDateTime getIssued() {
        return this.issued;
    }

    public void setIssued(@Nonnull OffsetDateTime issued) {
        this.issued = issued;
    }

    public MarketStructuresResponse locationId(@Nonnull Long locationId) {
        this.locationId = locationId;
        return this;
    }

    @Nonnull
    public Long getLocationId() {
        return this.locationId;
    }

    public void setLocationId(@Nonnull Long locationId) {
        this.locationId = locationId;
    }

    public MarketStructuresResponse minVolume(@Nonnull Integer minVolume) {
        this.minVolume = minVolume;
        return this;
    }

    @Nonnull
    public Integer getMinVolume() {
        return this.minVolume;
    }

    public void setMinVolume(@Nonnull Integer minVolume) {
        this.minVolume = minVolume;
    }

    public MarketStructuresResponse orderId(@Nonnull Long orderId) {
        this.orderId = orderId;
        return this;
    }

    @Nonnull
    public Long getOrderId() {
        return this.orderId;
    }

    public void setOrderId(@Nonnull Long orderId) {
        this.orderId = orderId;
    }

    public MarketStructuresResponse price(@Nonnull Double price) {
        this.price = price;
        return this;
    }

    @Nonnull
    public Double getPrice() {
        return this.price;
    }

    public void setPrice(@Nonnull Double price) {
        this.price = price;
    }

    public MarketStructuresResponse range(@Nonnull RangeEnum range) {
        this.rangeEnum = range;
        return this;
    }

    public MarketStructuresResponse rangeString(@Nonnull String range) {
        this.range = range;
        return this;
    }

    public RangeEnum getRange() {
        if (this.rangeEnum == null) {
            this.rangeEnum = RangeEnum.fromValue(this.range);
        }
        return this.rangeEnum;
    }

    public String getRangeString() {
        return this.range;
    }

    public void setRange(@Nonnull RangeEnum range) {
        this.rangeEnum = range;
    }

    public void setRangeString(@Nonnull String range) {
        this.range = range;
    }

    public MarketStructuresResponse typeId(@Nonnull Integer typeId) {
        this.typeId = typeId;
        return this;
    }

    @Nonnull
    public Integer getTypeId() {
        return this.typeId;
    }

    public void setTypeId(@Nonnull Integer typeId) {
        this.typeId = typeId;
    }

    public MarketStructuresResponse volumeRemain(@Nonnull Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
        return this;
    }

    @Nonnull
    public Integer getVolumeRemain() {
        return this.volumeRemain;
    }

    public void setVolumeRemain(@Nonnull Integer volumeRemain) {
        this.volumeRemain = volumeRemain;
    }

    public MarketStructuresResponse volumeTotal(@Nonnull Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
        return this;
    }

    @Nonnull
    public Integer getVolumeTotal() {
        return this.volumeTotal;
    }

    public void setVolumeTotal(@Nonnull Integer volumeTotal) {
        this.volumeTotal = volumeTotal;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MarketStructuresResponse marketStructuresResponse = (MarketStructuresResponse)o;
        return Objects.equals(this.duration, marketStructuresResponse.duration) && Objects.equals(this.isBuyOrder, marketStructuresResponse.isBuyOrder) && Objects.equals(this.issued, marketStructuresResponse.issued) && Objects.equals(this.locationId, marketStructuresResponse.locationId) && Objects.equals(this.minVolume, marketStructuresResponse.minVolume) && Objects.equals(this.orderId, marketStructuresResponse.orderId) && Objects.equals(this.price, marketStructuresResponse.price) && Objects.equals(this.range, marketStructuresResponse.range) && Objects.equals(this.typeId, marketStructuresResponse.typeId) && Objects.equals(this.volumeRemain, marketStructuresResponse.volumeRemain) && Objects.equals(this.volumeTotal, marketStructuresResponse.volumeTotal);
    }

    public int hashCode() {
        return Objects.hash(this.duration, this.isBuyOrder, this.issued, this.locationId, this.minVolume, this.orderId, this.price, this.range, this.typeId, this.volumeRemain, this.volumeTotal);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class MarketStructuresResponse {\n");
        sb.append("    duration: ").append(this.toIndentedString(this.duration)).append("\n");
        sb.append("    isBuyOrder: ").append(this.toIndentedString(this.isBuyOrder)).append("\n");
        sb.append("    issued: ").append(this.toIndentedString(this.issued)).append("\n");
        sb.append("    locationId: ").append(this.toIndentedString(this.locationId)).append("\n");
        sb.append("    minVolume: ").append(this.toIndentedString(this.minVolume)).append("\n");
        sb.append("    orderId: ").append(this.toIndentedString(this.orderId)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    range: ").append(this.toIndentedString(this.range)).append("\n");
        sb.append("    typeId: ").append(this.toIndentedString(this.typeId)).append("\n");
        sb.append("    volumeRemain: ").append(this.toIndentedString(this.volumeRemain)).append("\n");
        sb.append("    volumeTotal: ").append(this.toIndentedString(this.volumeTotal)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in MarketStructuresResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `MarketStructuresResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_RANGE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `range` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RANGE).toString()));
        }
        RangeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RANGE));
    }

    public static MarketStructuresResponse fromJson(String jsonString) throws IOException {
        return (MarketStructuresResponse)JSON.getGson().fromJson(jsonString, MarketStructuresResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DURATION);
        openapiFields.add(SERIALIZED_NAME_IS_BUY_ORDER);
        openapiFields.add(SERIALIZED_NAME_ISSUED);
        openapiFields.add(SERIALIZED_NAME_LOCATION_ID);
        openapiFields.add(SERIALIZED_NAME_MIN_VOLUME);
        openapiFields.add(SERIALIZED_NAME_ORDER_ID);
        openapiFields.add(SERIALIZED_NAME_PRICE);
        openapiFields.add(SERIALIZED_NAME_RANGE);
        openapiFields.add(SERIALIZED_NAME_TYPE_ID);
        openapiFields.add(SERIALIZED_NAME_VOLUME_REMAIN);
        openapiFields.add(SERIALIZED_NAME_VOLUME_TOTAL);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DURATION);
        openapiRequiredFields.add(SERIALIZED_NAME_IS_BUY_ORDER);
        openapiRequiredFields.add(SERIALIZED_NAME_ISSUED);
        openapiRequiredFields.add(SERIALIZED_NAME_LOCATION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_MIN_VOLUME);
        openapiRequiredFields.add(SERIALIZED_NAME_ORDER_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_PRICE);
        openapiRequiredFields.add(SERIALIZED_NAME_RANGE);
        openapiRequiredFields.add(SERIALIZED_NAME_TYPE_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME_REMAIN);
        openapiRequiredFields.add(SERIALIZED_NAME_VOLUME_TOTAL);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!MarketStructuresResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(MarketStructuresResponse.class));
            return new TypeAdapter<MarketStructuresResponse>(){

                public void write(JsonWriter out, MarketStructuresResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public MarketStructuresResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    MarketStructuresResponse.validateJsonElement(jsonElement);
                    return (MarketStructuresResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RangeEnum {
        STATION("station"),
        REGION("region"),
        SOLARSYSTEM("solarsystem"),
        _1("1"),
        _2("2"),
        _3("3"),
        _4("4"),
        _5("5"),
        _10("10"),
        _20("20"),
        _30("30"),
        _40("40");

        private String value;

        private RangeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RangeEnum fromValue(String value) {
            for (RangeEnum b : RangeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            RangeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<RangeEnum> {
            public void write(JsonWriter jsonWriter, RangeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RangeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RangeEnum.fromValue(value);
            }
        }
    }
}

