/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class Recipient
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_RECIPIENT_ID = "recipient_id";
    @SerializedName(value="recipient_id")
    @Nonnull
    private Integer recipientId;
    public static final String SERIALIZED_NAME_RECIPIENT_TYPE = "recipient_type";
    @SerializedName(value="recipient_type")
    @Nonnull
    private String recipientType;
    private RecipientTypeEnum recipientTypeEnum;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Recipient recipientId(@Nonnull Integer recipientId) {
        this.recipientId = recipientId;
        return this;
    }

    @Nonnull
    public Integer getRecipientId() {
        return this.recipientId;
    }

    public void setRecipientId(@Nonnull Integer recipientId) {
        this.recipientId = recipientId;
    }

    public Recipient recipientType(@Nonnull RecipientTypeEnum recipientType) {
        this.recipientTypeEnum = recipientType;
        return this;
    }

    public Recipient recipientTypeString(@Nonnull String recipientType) {
        this.recipientType = recipientType;
        return this;
    }

    public RecipientTypeEnum getRecipientType() {
        if (this.recipientTypeEnum == null) {
            this.recipientTypeEnum = RecipientTypeEnum.fromValue(this.recipientType);
        }
        return this.recipientTypeEnum;
    }

    public String getRecipientTypeString() {
        return this.recipientType;
    }

    public void setRecipientType(@Nonnull RecipientTypeEnum recipientType) {
        this.recipientTypeEnum = recipientType;
    }

    public void setRecipientTypeString(@Nonnull String recipientType) {
        this.recipientType = recipientType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Recipient recipient = (Recipient)o;
        return Objects.equals(this.recipientId, recipient.recipientId) && Objects.equals(this.recipientType, recipient.recipientType);
    }

    public int hashCode() {
        return Objects.hash(this.recipientId, this.recipientType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Recipient {\n");
        sb.append("    recipientId: ").append(this.toIndentedString(this.recipientId)).append("\n");
        sb.append("    recipientType: ").append(this.toIndentedString(this.recipientType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in Recipient is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `Recipient` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_RECIPIENT_TYPE).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `recipient_type` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_RECIPIENT_TYPE).toString()));
        }
        RecipientTypeEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_RECIPIENT_TYPE));
    }

    public static Recipient fromJson(String jsonString) throws IOException {
        return (Recipient)JSON.getGson().fromJson(jsonString, Recipient.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_RECIPIENT_ID);
        openapiFields.add(SERIALIZED_NAME_RECIPIENT_TYPE);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENT_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_RECIPIENT_TYPE);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Recipient.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Recipient.class));
            return new TypeAdapter<Recipient>(){

                public void write(JsonWriter out, Recipient value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Recipient read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    Recipient.validateJsonElement(jsonElement);
                    return (Recipient)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum RecipientTypeEnum {
        ALLIANCE("alliance"),
        CHARACTER("character"),
        CORPORATION("corporation"),
        MAILING_LIST("mailing_list");

        private String value;

        private RecipientTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static RecipientTypeEnum fromValue(String value) {
            for (RecipientTypeEnum b : RecipientTypeEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            RecipientTypeEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<RecipientTypeEnum> {
            public void write(JsonWriter jsonWriter, RecipientTypeEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public RecipientTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return RecipientTypeEnum.fromValue(value);
            }
        }
    }
}

