/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import net.troja.eve.esi.JSON;

public class SystemCostIndice
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_ACTIVITY = "activity";
    @SerializedName(value="activity")
    @Nonnull
    private String activity;
    private ActivityEnum activityEnum;
    public static final String SERIALIZED_NAME_COST_INDEX = "cost_index";
    @SerializedName(value="cost_index")
    @Nonnull
    private Float costIndex;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SystemCostIndice activity(@Nonnull ActivityEnum activity) {
        this.activityEnum = activity;
        return this;
    }

    public SystemCostIndice activityString(@Nonnull String activity) {
        this.activity = activity;
        return this;
    }

    public ActivityEnum getActivity() {
        if (this.activityEnum == null) {
            this.activityEnum = ActivityEnum.fromValue(this.activity);
        }
        return this.activityEnum;
    }

    public String getActivityString() {
        return this.activity;
    }

    public void setActivity(@Nonnull ActivityEnum activity) {
        this.activityEnum = activity;
    }

    public void setActivityString(@Nonnull String activity) {
        this.activity = activity;
    }

    public SystemCostIndice costIndex(@Nonnull Float costIndex) {
        this.costIndex = costIndex;
        return this;
    }

    @Nonnull
    public Float getCostIndex() {
        return this.costIndex;
    }

    public void setCostIndex(@Nonnull Float costIndex) {
        this.costIndex = costIndex;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemCostIndice systemCostIndice = (SystemCostIndice)o;
        return Objects.equals(this.activity, systemCostIndice.activity) && Objects.equals(this.costIndex, systemCostIndice.costIndex);
    }

    public int hashCode() {
        return Objects.hash(this.activity, this.costIndex);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemCostIndice {\n");
        sb.append("    activity: ").append(this.toIndentedString(this.activity)).append("\n");
        sb.append("    costIndex: ").append(this.toIndentedString(this.costIndex)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SystemCostIndice is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SystemCostIndice` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_ACTIVITY).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `activity` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ACTIVITY).toString()));
        }
        ActivityEnum.validateJsonElement(jsonObj.get(SERIALIZED_NAME_ACTIVITY));
    }

    public static SystemCostIndice fromJson(String jsonString) throws IOException {
        return (SystemCostIndice)JSON.getGson().fromJson(jsonString, SystemCostIndice.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_ACTIVITY);
        openapiFields.add(SERIALIZED_NAME_COST_INDEX);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ACTIVITY);
        openapiRequiredFields.add(SERIALIZED_NAME_COST_INDEX);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SystemCostIndice.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SystemCostIndice.class));
            return new TypeAdapter<SystemCostIndice>(){

                public void write(JsonWriter out, SystemCostIndice value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SystemCostIndice read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SystemCostIndice.validateJsonElement(jsonElement);
                    return (SystemCostIndice)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ActivityEnum {
        COPYING("copying"),
        DUPLICATING("duplicating"),
        INVENTION("invention"),
        MANUFACTURING("manufacturing"),
        NONE("none"),
        REACTION("reaction"),
        RESEARCHING_MATERIAL_EFFICIENCY("researching_material_efficiency"),
        RESEARCHING_TECHNOLOGY("researching_technology"),
        RESEARCHING_TIME_EFFICIENCY("researching_time_efficiency"),
        REVERSE_ENGINEERING("reverse_engineering");

        private String value;

        private ActivityEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ActivityEnum fromValue(String value) {
            for (ActivityEnum b : ActivityEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            return null;
        }

        public static void validateJsonElement(JsonElement jsonElement) throws IOException {
            String value = jsonElement.getAsString();
            ActivityEnum.fromValue(value);
        }

        public static class Adapter
        extends TypeAdapter<ActivityEnum> {
            public void write(JsonWriter jsonWriter, ActivityEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ActivityEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ActivityEnum.fromValue(value);
            }
        }
    }
}

