/*
 * Decompiled with CFR 0.152.
 */
package net.troja.eve.esi.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.troja.eve.esi.JSON;
import net.troja.eve.esi.model.Position;
import net.troja.eve.esi.model.SystemPlanet;

public class SystemResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String SERIALIZED_NAME_CONSTELLATION_ID = "constellation_id";
    @SerializedName(value="constellation_id")
    @Nonnull
    private Integer constellationId;
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    @Nonnull
    private String name;
    public static final String SERIALIZED_NAME_PLANETS = "planets";
    @SerializedName(value="planets")
    @Nullable
    private List<SystemPlanet> planets;
    public static final String SERIALIZED_NAME_POSITION = "position";
    @SerializedName(value="position")
    @Nonnull
    private Position position;
    public static final String SERIALIZED_NAME_SECURITY_CLASS = "security_class";
    @SerializedName(value="security_class")
    @Nullable
    private String securityClass;
    public static final String SERIALIZED_NAME_SECURITY_STATUS = "security_status";
    @SerializedName(value="security_status")
    @Nonnull
    private Float securityStatus;
    public static final String SERIALIZED_NAME_STAR_ID = "star_id";
    @SerializedName(value="star_id")
    @Nullable
    private Integer starId;
    public static final String SERIALIZED_NAME_STARGATES = "stargates";
    @SerializedName(value="stargates")
    @Nullable
    private List<Integer> stargates;
    public static final String SERIALIZED_NAME_STATIONS = "stations";
    @SerializedName(value="stations")
    @Nullable
    private List<Integer> stations;
    public static final String SERIALIZED_NAME_SYSTEM_ID = "system_id";
    @SerializedName(value="system_id")
    @Nonnull
    private Integer systemId;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public SystemResponse constellationId(@Nonnull Integer constellationId) {
        this.constellationId = constellationId;
        return this;
    }

    @Nonnull
    public Integer getConstellationId() {
        return this.constellationId;
    }

    public void setConstellationId(@Nonnull Integer constellationId) {
        this.constellationId = constellationId;
    }

    public SystemResponse name(@Nonnull String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(@Nonnull String name) {
        this.name = name;
    }

    public SystemResponse planets(@Nullable List<SystemPlanet> planets) {
        this.planets = planets;
        return this;
    }

    public SystemResponse addPlanetsItem(SystemPlanet planetsItem) {
        if (this.planets == null) {
            this.planets = new ArrayList<SystemPlanet>();
        }
        this.planets.add(planetsItem);
        return this;
    }

    @Nullable
    public List<SystemPlanet> getPlanets() {
        return this.planets;
    }

    public void setPlanets(@Nullable List<SystemPlanet> planets) {
        this.planets = planets;
    }

    public SystemResponse position(@Nonnull Position position) {
        this.position = position;
        return this;
    }

    @Nonnull
    public Position getPosition() {
        return this.position;
    }

    public void setPosition(@Nonnull Position position) {
        this.position = position;
    }

    public SystemResponse securityClass(@Nullable String securityClass) {
        this.securityClass = securityClass;
        return this;
    }

    @Nullable
    public String getSecurityClass() {
        return this.securityClass;
    }

    public void setSecurityClass(@Nullable String securityClass) {
        this.securityClass = securityClass;
    }

    public SystemResponse securityStatus(@Nonnull Float securityStatus) {
        this.securityStatus = securityStatus;
        return this;
    }

    @Nonnull
    public Float getSecurityStatus() {
        return this.securityStatus;
    }

    public void setSecurityStatus(@Nonnull Float securityStatus) {
        this.securityStatus = securityStatus;
    }

    public SystemResponse starId(@Nullable Integer starId) {
        this.starId = starId;
        return this;
    }

    @Nullable
    public Integer getStarId() {
        return this.starId;
    }

    public void setStarId(@Nullable Integer starId) {
        this.starId = starId;
    }

    public SystemResponse stargates(@Nullable List<Integer> stargates) {
        this.stargates = stargates;
        return this;
    }

    public SystemResponse addStargatesItem(Integer stargatesItem) {
        if (this.stargates == null) {
            this.stargates = new ArrayList<Integer>();
        }
        this.stargates.add(stargatesItem);
        return this;
    }

    @Nullable
    public List<Integer> getStargates() {
        return this.stargates;
    }

    public void setStargates(@Nullable List<Integer> stargates) {
        this.stargates = stargates;
    }

    public SystemResponse stations(@Nullable List<Integer> stations) {
        this.stations = stations;
        return this;
    }

    public SystemResponse addStationsItem(Integer stationsItem) {
        if (this.stations == null) {
            this.stations = new ArrayList<Integer>();
        }
        this.stations.add(stationsItem);
        return this;
    }

    @Nullable
    public List<Integer> getStations() {
        return this.stations;
    }

    public void setStations(@Nullable List<Integer> stations) {
        this.stations = stations;
    }

    public SystemResponse systemId(@Nonnull Integer systemId) {
        this.systemId = systemId;
        return this;
    }

    @Nonnull
    public Integer getSystemId() {
        return this.systemId;
    }

    public void setSystemId(@Nonnull Integer systemId) {
        this.systemId = systemId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SystemResponse systemResponse = (SystemResponse)o;
        return Objects.equals(this.constellationId, systemResponse.constellationId) && Objects.equals(this.name, systemResponse.name) && Objects.equals(this.planets, systemResponse.planets) && Objects.equals(this.position, systemResponse.position) && Objects.equals(this.securityClass, systemResponse.securityClass) && Objects.equals(this.securityStatus, systemResponse.securityStatus) && Objects.equals(this.starId, systemResponse.starId) && Objects.equals(this.stargates, systemResponse.stargates) && Objects.equals(this.stations, systemResponse.stations) && Objects.equals(this.systemId, systemResponse.systemId);
    }

    public int hashCode() {
        return Objects.hash(this.constellationId, this.name, this.planets, this.position, this.securityClass, this.securityStatus, this.starId, this.stargates, this.stations, this.systemId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SystemResponse {\n");
        sb.append("    constellationId: ").append(this.toIndentedString(this.constellationId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    planets: ").append(this.toIndentedString(this.planets)).append("\n");
        sb.append("    position: ").append(this.toIndentedString(this.position)).append("\n");
        sb.append("    securityClass: ").append(this.toIndentedString(this.securityClass)).append("\n");
        sb.append("    securityStatus: ").append(this.toIndentedString(this.securityStatus)).append("\n");
        sb.append("    starId: ").append(this.toIndentedString(this.starId)).append("\n");
        sb.append("    stargates: ").append(this.toIndentedString(this.stargates)).append("\n");
        sb.append("    stations: ").append(this.toIndentedString(this.stations)).append("\n");
        sb.append("    systemId: ").append(this.toIndentedString(this.systemId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        JsonArray jsonArrayplanets;
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in SystemResponse is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `SystemResponse` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_PLANETS) != null && !jsonObj.get(SERIALIZED_NAME_PLANETS).isJsonNull() && (jsonArrayplanets = jsonObj.getAsJsonArray(SERIALIZED_NAME_PLANETS)) != null) {
            if (!jsonObj.get(SERIALIZED_NAME_PLANETS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `planets` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_PLANETS).toString()));
            }
            for (int i = 0; i < jsonArrayplanets.size(); ++i) {
                SystemPlanet.validateJsonElement(jsonArrayplanets.get(i));
            }
        }
        Position.validateJsonElement(jsonObj.get(SERIALIZED_NAME_POSITION));
        if (jsonObj.get(SERIALIZED_NAME_SECURITY_CLASS) != null && !jsonObj.get(SERIALIZED_NAME_SECURITY_CLASS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_SECURITY_CLASS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `security_class` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_SECURITY_CLASS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STARGATES) != null && !jsonObj.get(SERIALIZED_NAME_STARGATES).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STARGATES).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stargates` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STARGATES).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_STATIONS) != null && !jsonObj.get(SERIALIZED_NAME_STATIONS).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_STATIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `stations` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_STATIONS).toString()));
        }
    }

    public static SystemResponse fromJson(String jsonString) throws IOException {
        return (SystemResponse)JSON.getGson().fromJson(jsonString, SystemResponse.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_CONSTELLATION_ID);
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_PLANETS);
        openapiFields.add(SERIALIZED_NAME_POSITION);
        openapiFields.add(SERIALIZED_NAME_SECURITY_CLASS);
        openapiFields.add(SERIALIZED_NAME_SECURITY_STATUS);
        openapiFields.add(SERIALIZED_NAME_STAR_ID);
        openapiFields.add(SERIALIZED_NAME_STARGATES);
        openapiFields.add(SERIALIZED_NAME_STATIONS);
        openapiFields.add(SERIALIZED_NAME_SYSTEM_ID);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_CONSTELLATION_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_POSITION);
        openapiRequiredFields.add(SERIALIZED_NAME_SECURITY_STATUS);
        openapiRequiredFields.add(SERIALIZED_NAME_SYSTEM_ID);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!SystemResponse.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(SystemResponse.class));
            return new TypeAdapter<SystemResponse>(){

                public void write(JsonWriter out, SystemResponse value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public SystemResponse read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    SystemResponse.validateJsonElement(jsonElement);
                    return (SystemResponse)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

