/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.obfuscate.processor;

import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedOptions;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.tools.Diagnostic;
import net.truelicense.obfuscate.Obfuscate;
import net.truelicense.obfuscate.ObfuscatedString;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@SupportedSourceVersion(value=SourceVersion.RELEASE_8)
@SupportedAnnotationTypes(value={"Obfuscate"})
@SupportedOptions(value={"net.truelicense.obfuscate.verbose", "net.truelicense.obfuscate.processor.verbose"})
public class ObfuscateProcessor
extends AbstractProcessor {
    private boolean verbose;
    static final /* synthetic */ boolean $assertionsDisabled;

    @Override
    public void init(ProcessingEnvironment processingEnvironment) {
        super.init(processingEnvironment);
        Set<String> set = this.getSupportedOptions();
        Map<String, String> map = processingEnvironment.getOptions();
        this.verbose = false;
        for (String string : set) {
            this.verbose |= Boolean.parseBoolean(map.get(string));
        }
    }

    @Override
    public boolean process(Set<? extends TypeElement> set, RoundEnvironment roundEnvironment) {
        if (roundEnvironment.errorRaised() || roundEnvironment.processingOver()) {
            return true;
        }
        for (TypeElement typeElement : set) {
            if (!$assertionsDisabled && !typeElement.asType().toString().equals(Obfuscate.class.getName())) {
                throw new AssertionError();
            }
            for (Element element : roundEnvironment.getElementsAnnotatedWith(typeElement)) {
                VariableElement variableElement = (VariableElement)element;
                TypeElement typeElement2 = (TypeElement)variableElement.getEnclosingElement();
                try {
                    String string = (String)variableElement.getConstantValue();
                    if (ObfuscateProcessor.keepField(variableElement)) {
                        this.warn(ObfuscateProcessor._string#0(), variableElement);
                    }
                    this.debug(ObfuscatedString.obfuscate(string), variableElement);
                }
                catch (RuntimeException runtimeException) {
                    this.error(ObfuscateProcessor._string#1(), variableElement);
                }
            }
        }
        return true;
    }

    private static boolean keepField(Element element) {
        Set<Modifier> set = element.getModifiers();
        return set.contains((Object)Modifier.PROTECTED) || set.contains((Object)Modifier.PUBLIC) || !set.contains((Object)Modifier.STATIC);
    }

    private void debug(CharSequence charSequence, Element element) {
        if (this.verbose) {
            this.getMessager().printMessage(Diagnostic.Kind.NOTE, charSequence, element);
        }
    }

    private void warn(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.WARNING, charSequence, element);
    }

    private void error(CharSequence charSequence, Element element) {
        this.getMessager().printMessage(Diagnostic.Kind.ERROR, charSequence, element);
    }

    private Messager getMessager() {
        return this.processingEnv.getMessager();
    }

    static {
        ObfuscateProcessor.$assertionsDisabled = !ObfuscateProcessor.class.desiredAssertionStatus();
    }

    private static /* synthetic */ String _string#0() {
        return new ObfuscatedString(new long[]{7414986620339263178L, -940015589153742407L, 2043848115020566379L, -1696412075805630793L, 2222558013407496344L, 6409232767389780652L, 9079710556924875858L, 3582774112758664621L, -5953414556420815508L, 5142522664512113604L, -1005834190858866143L, 6507509823308249608L, 8563935873477640362L, 4863092635414451789L, -6028253982329146212L, -1268097053027021203L}).toString();
    }

    private static /* synthetic */ String _string#1() {
        return new ObfuscatedString(new long[]{-4848150472550548288L, -7074664581688124538L, 942970070437230364L, 7986944494504543485L, -325923846602185320L, -166539062028538656L, 522609595684494283L, -6627290022318268078L}).toString();
    }
}

