/*
 * Decompiled with CFR 0.152.
 */
package net.truelicense.v2.xml.codec;

import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Type;
import java.util.Objects;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import net.truelicense.api.codec.Codec;
import net.truelicense.api.codec.Decoder;
import net.truelicense.api.codec.Encoder;
import net.truelicense.api.io.Sink;
import net.truelicense.api.io.Source;
import net.truelicense.obfuscate.ObfuscatedString;

public class JaxbCodec
implements Codec {
    protected final JAXBContext context;

    public JaxbCodec(JAXBContext jAXBContext) {
        this.context = Objects.requireNonNull(jAXBContext);
    }

    public String contentType() {
        return JaxbCodec.APPLICATION_XML_WITH_UTF_8();
    }

    public String contentTransferEncoding() {
        return JaxbCodec.EIGHT_BIT();
    }

    public Encoder encoder(Sink sink) {
        return object -> {
            try (OutputStream outputStream = sink.output();){
                this.marshaller().marshal(object, outputStream);
            }
        };
    }

    protected Marshaller marshaller() throws JAXBException {
        return this.context.createMarshaller();
    }

    public Decoder decoder(final Source source) {
        return new Decoder(){

            public <T> T decode(Type type) throws Exception {
                try (InputStream inputStream = source.input();){
                    Object object = JaxbCodec.this.unmarshaller().unmarshal(inputStream);
                    return (T)object;
                }
            }
        };
    }

    protected Unmarshaller unmarshaller() throws JAXBException {
        return this.context.createUnmarshaller();
    }

    private static final /* synthetic */ String APPLICATION_XML_WITH_UTF_8() {
        return new ObfuscatedString(new long[]{2467469204457384423L, 5843184540866888993L, 4786006470383636146L, -8321003097616700011L, 5381421857845804899L}).toString();
    }

    private static final /* synthetic */ String EIGHT_BIT() {
        return new ObfuscatedString(new long[]{9165197060619874408L, 5917970138284679356L}).toString();
    }
}

