/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.support.ProxyDataSourceBuilder;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.observation.boot.autoconfigure.DataSourceNameResolver;
import net.ttddyy.observation.boot.autoconfigure.DataSourceProxyBuilderConfigurer;
import net.ttddyy.observation.boot.autoconfigure.DataSourceProxyConnectionIdManagerProvider;
import net.ttddyy.observation.boot.autoconfigure.JdbcProperties;
import net.ttddyy.observation.boot.autoconfigure.ProxyDataSourceBuilderCustomizer;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.config.BeanPostProcessor;

public class DataSourceObservationBeanPostProcessor
implements BeanPostProcessor {
    private final ObjectProvider<JdbcProperties> jdbcPropertiesProvider;
    private final ObjectProvider<DataSourceNameResolver> dataSourceNameResolverProvider;
    private final ObjectProvider<QueryExecutionListener> listenersProvider;
    private final ObjectProvider<MethodExecutionListener> methodExecutionListenersProvider;
    private final ObjectProvider<ParameterTransformer> parameterTransformerProvider;
    private final ObjectProvider<QueryTransformer> queryTransformerProvider;
    private final ObjectProvider<ResultSetProxyLogicFactory> resultSetProxyLogicFactoryProvider;
    private final ObjectProvider<DataSourceProxyConnectionIdManagerProvider> dataSourceProxyConnectionIdManagerProviderProvider;
    private DataSourceProxyBuilderConfigurer dataSourceProxyBuilderConfigurer;
    private final ObjectProvider<ProxyDataSourceBuilderCustomizer> proxyDataSourceBuilderCustomizers;

    public DataSourceObservationBeanPostProcessor(ObjectProvider<JdbcProperties> jdbcPropertiesProvider, ObjectProvider<DataSourceNameResolver> dataSourceNameResolverProvider, ObjectProvider<QueryExecutionListener> listenersProvider, ObjectProvider<MethodExecutionListener> methodExecutionListenersProvider, ObjectProvider<ParameterTransformer> parameterTransformerProvider, ObjectProvider<QueryTransformer> queryTransformerProvider, ObjectProvider<ResultSetProxyLogicFactory> resultSetProxyLogicFactoryProvider, ObjectProvider<DataSourceProxyConnectionIdManagerProvider> dataSourceProxyConnectionIdManagerProviderProvider, ObjectProvider<ProxyDataSourceBuilderCustomizer> proxyDataSourceBuilderCustomizers) {
        this.jdbcPropertiesProvider = jdbcPropertiesProvider;
        this.dataSourceNameResolverProvider = dataSourceNameResolverProvider;
        this.listenersProvider = listenersProvider;
        this.methodExecutionListenersProvider = methodExecutionListenersProvider;
        this.parameterTransformerProvider = parameterTransformerProvider;
        this.queryTransformerProvider = queryTransformerProvider;
        this.resultSetProxyLogicFactoryProvider = resultSetProxyLogicFactoryProvider;
        this.dataSourceProxyConnectionIdManagerProviderProvider = dataSourceProxyConnectionIdManagerProviderProvider;
        this.proxyDataSourceBuilderCustomizers = proxyDataSourceBuilderCustomizers;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof DataSource) {
            DataSource dataSource = (DataSource)bean;
            if (!ScopedProxyUtils.isScopedTarget((String)beanName) && !this.isExcludedBean(beanName)) {
                String dataSourceName = ((DataSourceNameResolver)this.dataSourceNameResolverProvider.getObject()).resolve(beanName, dataSource);
                ProxyDataSourceBuilder builder = ProxyDataSourceBuilder.create((String)dataSourceName, (DataSource)dataSource);
                this.getConfigurer().configure(builder);
                this.proxyDataSourceBuilderCustomizers.orderedStream().forEach(customizer -> customizer.customize(builder, dataSource, beanName, dataSourceName));
                return builder.build();
            }
        }
        return bean;
    }

    private DataSourceProxyBuilderConfigurer getConfigurer() {
        if (this.dataSourceProxyBuilderConfigurer == null) {
            this.dataSourceProxyBuilderConfigurer = new DataSourceProxyBuilderConfigurer(this.getJdbcProperties(), this.listenersProvider.orderedStream().toList(), this.methodExecutionListenersProvider.orderedStream().toList(), (ParameterTransformer)this.parameterTransformerProvider.getIfAvailable(), (QueryTransformer)this.queryTransformerProvider.getIfAvailable(), (ResultSetProxyLogicFactory)this.resultSetProxyLogicFactoryProvider.getIfAvailable(), (DataSourceProxyConnectionIdManagerProvider)this.dataSourceProxyConnectionIdManagerProviderProvider.getIfAvailable());
        }
        return this.dataSourceProxyBuilderConfigurer;
    }

    private boolean isExcludedBean(String beanName) {
        return this.getJdbcProperties().getExcludedDataSourceBeanNames().contains(beanName);
    }

    private JdbcProperties getJdbcProperties() {
        return (JdbcProperties)this.jdbcPropertiesProvider.getObject();
    }
}

