/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.boot.autoconfigure;

import io.micrometer.observation.ObservationConvention;
import io.micrometer.observation.ObservationFilter;
import io.micrometer.observation.ObservationRegistry;
import io.micrometer.tracing.Tracer;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.listener.MethodExecutionListener;
import net.ttddyy.dsproxy.listener.QueryExecutionListener;
import net.ttddyy.dsproxy.proxy.GlobalConnectionIdManager;
import net.ttddyy.dsproxy.proxy.ResultSetProxyLogicFactory;
import net.ttddyy.dsproxy.transform.ParameterTransformer;
import net.ttddyy.dsproxy.transform.QueryTransformer;
import net.ttddyy.observation.boot.autoconfigure.DataSourceNameResolver;
import net.ttddyy.observation.boot.autoconfigure.DataSourceObservationBeanPostProcessor;
import net.ttddyy.observation.boot.autoconfigure.DataSourceProxyConnectionIdManagerProvider;
import net.ttddyy.observation.boot.autoconfigure.DefaultDataSourceNameResolver;
import net.ttddyy.observation.boot.autoconfigure.JdbcProperties;
import net.ttddyy.observation.boot.autoconfigure.ProxyDataSourceBuilderCustomizer;
import net.ttddyy.observation.boot.event.JdbcEventPublishingListener;
import net.ttddyy.observation.tracing.ConnectionObservationConvention;
import net.ttddyy.observation.tracing.ConnectionTracingObservationHandler;
import net.ttddyy.observation.tracing.DataSourceObservationListener;
import net.ttddyy.observation.tracing.GeneratedKeysObservationConvention;
import net.ttddyy.observation.tracing.HikariJdbcObservationFilter;
import net.ttddyy.observation.tracing.QueryObservationConvention;
import net.ttddyy.observation.tracing.QueryTracingObservationHandler;
import net.ttddyy.observation.tracing.ResultSetObservationConvention;
import net.ttddyy.observation.tracing.ResultSetTracingObservationHandler;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionMessage;
import org.springframework.boot.autoconfigure.condition.ConditionOutcome;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.SpringBootCondition;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.context.properties.bind.BindException;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.boot.jdbc.autoconfigure.DataSourceAutoConfiguration;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationAutoConfiguration;
import org.springframework.boot.micrometer.observation.autoconfigure.ObservationRegistryCustomizer;
import org.springframework.boot.micrometer.tracing.autoconfigure.ConditionalOnEnabledTracingExport;
import org.springframework.boot.micrometer.tracing.autoconfigure.MicrometerTracingAutoConfiguration;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ConditionContext;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.Environment;
import org.springframework.core.type.AnnotatedTypeMetadata;
import org.springframework.util.Assert;

@AutoConfiguration(after={ObservationAutoConfiguration.class, MicrometerTracingAutoConfiguration.class, DataSourceAutoConfiguration.class})
@EnableConfigurationProperties(value={JdbcProperties.class})
@ConditionalOnClass(value={DataSource.class, ObservationRegistry.class})
@ConditionalOnProperty(prefix="jdbc.datasource-proxy", name={"enabled"}, havingValue="true", matchIfMissing=true)
public class DataSourceObservationAutoConfiguration {
    public static final int OBSERVATION_LISTENER_ORDER = 1000;
    public static final int EVENT_PUBLISHING_LISTENER_ORDER = 1100;

    @Bean
    @Order(value=1000)
    public DataSourceObservationListener dataSourceObservationListener(ObjectProvider<ObservationRegistry> registry, JdbcProperties jdbcProperties, ObjectProvider<ObservationConvention<?>> observationConventions) {
        Set supportedDocumentations = jdbcProperties.getIncludes().stream().map(include -> include.supportedDocumentation).collect(Collectors.toSet());
        DataSourceObservationListener listener = new DataSourceObservationListener(() -> registry.getObject());
        listener.setIncludeParameterValues(jdbcProperties.getDatasourceProxy().isIncludeParameterValues());
        listener.setSupportedTypes(supportedDocumentations);
        listener.setIncludeResultSetOperations(jdbcProperties.getResultsetOperations().isEnabled());
        observationConventions.orderedStream().forEach(convention -> {
            if (convention instanceof ConnectionObservationConvention) {
                listener.setConnectionObservationConvention((ConnectionObservationConvention)convention);
            } else if (convention instanceof QueryObservationConvention) {
                listener.setQueryObservationConvention((QueryObservationConvention)convention);
            } else if (convention instanceof GeneratedKeysObservationConvention) {
                listener.setGeneratedKeysObservationConvention((GeneratedKeysObservationConvention)convention);
            } else if (convention instanceof ResultSetObservationConvention) {
                listener.setResultSetObservationConvention((ResultSetObservationConvention)convention);
            }
        });
        return listener;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceProxyConnectionIdManagerProvider observationConnectionIdManagerProvider() {
        return GlobalConnectionIdManager::new;
    }

    @Bean
    @ConditionalOnMissingBean
    public DataSourceNameResolver dataSourceNameResolver() {
        return new DefaultDataSourceNameResolver();
    }

    @Bean
    public static DataSourceObservationBeanPostProcessor dataSourceObservationBeanPostProcessor(ObjectProvider<JdbcProperties> jdbcProperties, ObjectProvider<DataSourceNameResolver> dataSourceNameResolvers, ObjectProvider<QueryExecutionListener> listeners, ObjectProvider<MethodExecutionListener> methodExecutionListeners, ObjectProvider<ParameterTransformer> parameterTransformer, ObjectProvider<QueryTransformer> queryTransformer, ObjectProvider<ResultSetProxyLogicFactory> resultSetProxyLogicFactory, ObjectProvider<ResultSetProxyLogicFactory> generatedKeysProxyLogicFactory, ObjectProvider<DataSourceProxyConnectionIdManagerProvider> dataSourceProxyConnectionIdManagerProvider, ObjectProvider<ProxyDataSourceBuilderCustomizer> proxyDataSourceBuilderCustomizers) {
        return new DataSourceObservationBeanPostProcessor(jdbcProperties, dataSourceNameResolvers, listeners, methodExecutionListeners, parameterTransformer, queryTransformer, resultSetProxyLogicFactory, generatedKeysProxyLogicFactory, dataSourceProxyConnectionIdManagerProvider, proxyDataSourceBuilderCustomizers);
    }

    @Bean
    @Order(value=1100)
    @ConditionalOnProperty(prefix="jdbc.event", name={"enabled"}, havingValue="true")
    JdbcEventPublishingListener jdbcEventPublishingListener(ApplicationEventPublisher publisher) {
        return new JdbcEventPublishingListener(publisher);
    }

    static class OnTraceTypeCondition
    extends SpringBootCondition {
        private static final String INCLUDES_PROP_KEY = "jdbc.includes";

        OnTraceTypeCondition() {
        }

        public ConditionOutcome getMatchOutcome(ConditionContext context, AnnotatedTypeMetadata metadata) {
            Map attributes = metadata.getAnnotationAttributes(ConditionalOnTraceType.class.getName());
            Assert.notNull((Object)attributes, (String)"attributes must not be null");
            JdbcProperties.TraceType requiredTraceType = (JdbcProperties.TraceType)((Object)attributes.get("value"));
            Environment environment = context.getEnvironment();
            Set traceTypes = Set.of();
            StringBuilder details = new StringBuilder();
            details.append("(");
            details.append(INCLUDES_PROP_KEY);
            details.append("=");
            if (environment.containsProperty(INCLUDES_PROP_KEY)) {
                try {
                    traceTypes = (Set)Binder.get((Environment)environment).bindOrCreate(INCLUDES_PROP_KEY, Bindable.setOf(JdbcProperties.TraceType.class));
                    details.append(environment.getProperty(INCLUDES_PROP_KEY));
                }
                catch (BindException ex) {
                    details.append("<Bind Failed>");
                }
            } else {
                traceTypes = new JdbcProperties().getIncludes();
                details.append(traceTypes);
                details.append("(default properties)");
            }
            details.append(")");
            ConditionMessage.Builder message = ConditionMessage.forCondition(ConditionalOnTraceType.class, (Object[])new Object[]{details});
            if (traceTypes.contains((Object)requiredTraceType)) {
                return ConditionOutcome.match((ConditionMessage)message.found("TraceType").items(new Object[]{requiredTraceType}));
            }
            return ConditionOutcome.noMatch((ConditionMessage)message.didNotFind("TraceType").items(new Object[]{requiredTraceType}));
        }
    }

    @Target(value={ElementType.TYPE, ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    @Documented
    @Conditional(value={OnTraceTypeCondition.class})
    static @interface ConditionalOnTraceType {
        public JdbcProperties.TraceType value();
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnEnabledTracingExport
    static class DataSourceTracing {
        private static final int ORDER = 2147481647;

        DataSourceTracing() {
        }

        @Bean
        @ConditionalOnTraceType(value=JdbcProperties.TraceType.CONNECTION)
        @Order(value=2147481647)
        public ConnectionTracingObservationHandler connectionTracingObservationHandler(Tracer tracer) {
            return new ConnectionTracingObservationHandler(tracer);
        }

        @Bean
        @ConditionalOnTraceType(value=JdbcProperties.TraceType.QUERY)
        @Order(value=2147481647)
        public QueryTracingObservationHandler queryTracingObservationHandler(Tracer tracer) {
            return new QueryTracingObservationHandler(tracer);
        }

        @Bean
        @ConditionalOnTraceType(value=JdbcProperties.TraceType.FETCH)
        @Order(value=2147481647)
        public ResultSetTracingObservationHandler resultSetTracingObservationHandler(Tracer tracer) {
            return new ResultSetTracingObservationHandler(tracer);
        }
    }

    @Configuration(proxyBeanMethods=false)
    @ConditionalOnClass(name={"com.zaxxer.hikari.HikariDataSource"})
    static class Hikari {
        Hikari() {
        }

        @Bean
        public HikariJdbcObservationFilter hikariJdbcObservationFilter() {
            return new HikariJdbcObservationFilter();
        }

        @Bean
        public ObservationRegistryCustomizer<ObservationRegistry> hikariJdbcObservationFilterObservationRegistryCustomizer(HikariJdbcObservationFilter hikariJdbcObservationFilter) {
            return registry -> registry.observationConfig().observationFilter((ObservationFilter)hikariJdbcObservationFilter);
        }
    }
}

