/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import io.micrometer.common.lang.Nullable;
import io.micrometer.observation.Observation;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import net.ttddyy.dsproxy.ConnectionInfo;
import net.ttddyy.observation.tracing.ResultSetContext;

public interface ConnectionAttributesManager {
    @Nullable
    public ConnectionAttributes put(String var1, ConnectionAttributes var2);

    @Nullable
    public ConnectionAttributes get(String var1);

    @Nullable
    public ConnectionAttributes remove(String var1);

    public static class ResultSetAttributes {
        Statement statement;
        Observation.Scope scope;
        ResultSetContext context;
    }

    public static class ResultSetAttributesManager {
        Map<ResultSet, ResultSetAttributes> byResultSet = new ConcurrentHashMap<ResultSet, ResultSetAttributes>();
        Map<ResultSet, Statement> statements = new ConcurrentHashMap<ResultSet, Statement>();

        ResultSetAttributes add(ResultSet resultSet, @Nullable Statement statement, ResultSetAttributes attributes) {
            this.byResultSet.put(resultSet, attributes);
            if (statement != null) {
                this.statements.put(resultSet, statement);
            }
            return attributes;
        }

        @Nullable
        ResultSetAttributes getByResultSet(ResultSet resultSet) {
            return this.byResultSet.get(resultSet);
        }

        @Nullable
        ResultSetAttributes removeByResultSet(ResultSet resultSet) {
            this.statements.remove(resultSet);
            return this.byResultSet.remove(resultSet);
        }

        Set<ResultSetAttributes> removeByStatement(Statement statement) {
            HashSet<ResultSet> resultSets = new HashSet<ResultSet>();
            Iterator<Map.Entry<ResultSet, Statement>> iter = this.statements.entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry<ResultSet, Statement> entry = iter.next();
                if (!entry.getValue().equals(statement)) continue;
                resultSets.add(entry.getKey());
                iter.remove();
            }
            return resultSets.stream().map(this.byResultSet::remove).filter(Objects::nonNull).collect(Collectors.toSet());
        }

        Set<ResultSetAttributes> removeAll() {
            HashSet<ResultSetAttributes> attributes = new HashSet<ResultSetAttributes>(this.byResultSet.values());
            this.byResultSet.clear();
            this.statements.clear();
            return attributes;
        }
    }

    public static class ConnectionAttributes {
        DataSource dataSource;
        ConnectionInfo connectionInfo;
        @Nullable
        String host;
        @Nullable
        int port;
        Observation.Scope scope;
        ResultSetAttributesManager resultSetAttributesManager = new ResultSetAttributesManager();
    }
}

