/*
 * Decompiled with CFR 0.152.
 */
package net.ttddyy.observation.tracing;

import com.zaxxer.hikari.HikariDataSource;
import io.micrometer.common.util.StringUtils;
import io.micrometer.observation.Observation;
import io.micrometer.observation.ObservationFilter;
import java.sql.SQLException;
import javax.sql.DataSource;
import net.ttddyy.observation.tracing.ConnectionContext;
import net.ttddyy.observation.tracing.JdbcObservationDocumentation;

public class HikariJdbcObservationFilter
implements ObservationFilter {
    public Observation.Context map(Observation.Context context) {
        String poolName;
        HikariDataSource hikariDataSource;
        if (!(context instanceof ConnectionContext)) {
            return context;
        }
        ConnectionContext connectionContext = (ConnectionContext)context;
        DataSource dataSource = connectionContext.getDataSource();
        try {
            if (!dataSource.isWrapperFor(HikariDataSource.class)) {
                return context;
            }
            hikariDataSource = dataSource.unwrap(HikariDataSource.class);
        }
        catch (SQLException exception) {
            return context;
        }
        String driverClassName = hikariDataSource.getDriverClassName();
        if (StringUtils.isNotBlank((String)driverClassName)) {
            context.addLowCardinalityKeyValue(JdbcObservationDocumentation.ConnectionKeyNames.DATASOURCE_DRIVER.withValue(driverClassName));
        }
        if (StringUtils.isNotBlank((String)(poolName = hikariDataSource.getPoolName()))) {
            context.addLowCardinalityKeyValue(JdbcObservationDocumentation.ConnectionKeyNames.DATASOURCE_POOL.withValue(poolName));
        }
        return context;
    }
}

