/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.slideshare.api.domain;

import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Slideshow {
    private static Pattern THUMBNAIL_SIZE_PATTERN = Pattern.compile("\\[(?<width>\\d+),(?<height>\\d+)\\]");
    private String id;
    private String title;
    private String description;
    private Status status;
    private String username;
    private String url;
    private String thumbnailUrl;
    private String thumbnailSize;
    private String thumbnailSmallURL;
    private String embed;
    private Date created;
    private Date updated;
    private String language;
    private String format;
    private boolean isDownloadable;
    private String downloadUrl;
    private SlideshowType slideshowType;
    private boolean inContest;
    private String transcript;
    private String userId;
    private String externalAppUserId;
    private String pptLocation;
    private String strippedTitle;
    private List<Tag> tags;
    private boolean audio;
    private long numDownloads;
    private long numViews;
    private long numComments;
    private long numFavorites;
    private long numSlides;
    private List<RelatedSlideshow> relatedSlideshows;
    private boolean isPrivate;
    private boolean isFlagged;
    private boolean showOnSlideShare;
    private boolean isSecretUrl;
    private boolean allowEmbed;
    private boolean shareWithContacts;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getThumbnailUrl() {
        return this.thumbnailUrl;
    }

    public void setThumbnailUrl(String thumbnailUrl) {
        this.thumbnailUrl = thumbnailUrl;
    }

    public String getThumbnailSize() {
        return this.thumbnailSize;
    }

    public void setThumbnailSize(String thumbnailSize) {
        this.thumbnailSize = thumbnailSize;
    }

    public String getThumbnailSmallURL() {
        return this.thumbnailSmallURL;
    }

    public void setThumbnailSmallURL(String thumbnailSmallURL) {
        this.thumbnailSmallURL = thumbnailSmallURL;
    }

    public String getEmbed() {
        return this.embed;
    }

    public void setEmbed(String embed) {
        this.embed = embed;
    }

    public Date getCreated() {
        return this.created;
    }

    public void setCreated(Date created) {
        this.created = created;
    }

    public Date getUpdated() {
        return this.updated;
    }

    public void setUpdated(Date updated) {
        this.updated = updated;
    }

    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public boolean isDownloadable() {
        return this.isDownloadable;
    }

    public void setDownloadable(boolean isDownloadable) {
        this.isDownloadable = isDownloadable;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public void setDownloadUrl(String downloadUrl) {
        this.downloadUrl = downloadUrl;
    }

    public SlideshowType getSlideshowType() {
        return this.slideshowType;
    }

    public void setSlideshowType(SlideshowType slideshowType) {
        this.slideshowType = slideshowType;
    }

    public boolean isInContest() {
        return this.inContest;
    }

    public void setInContest(boolean inContest) {
        this.inContest = inContest;
    }

    public String getTranscript() {
        return this.transcript;
    }

    public void setTranscript(String transcript) {
        this.transcript = transcript;
    }

    public String getUserId() {
        return this.userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getExternalAppUserId() {
        return this.externalAppUserId;
    }

    public void setExternalAppUserId(String externalAppUserId) {
        this.externalAppUserId = externalAppUserId;
    }

    public String getPptLocation() {
        return this.pptLocation;
    }

    public void setPptLocation(String pptLocation) {
        this.pptLocation = pptLocation;
    }

    public String getStrippedTitle() {
        return this.strippedTitle;
    }

    public void setStrippedTitle(String strippedTitle) {
        this.strippedTitle = strippedTitle;
    }

    public List<Tag> getTags() {
        return this.tags;
    }

    public void setTags(List<Tag> tags) {
        this.tags = tags;
    }

    public boolean isAudio() {
        return this.audio;
    }

    public void setAudio(boolean audio) {
        this.audio = audio;
    }

    public long getNumDownloads() {
        return this.numDownloads;
    }

    public void setNumDownloads(long numDownloads) {
        this.numDownloads = numDownloads;
    }

    public long getNumViews() {
        return this.numViews;
    }

    public void setNumViews(long numViews) {
        this.numViews = numViews;
    }

    public long getNumComments() {
        return this.numComments;
    }

    public void setNumComments(long numComments) {
        this.numComments = numComments;
    }

    public long getNumFavorites() {
        return this.numFavorites;
    }

    public void setNumFavorites(long numFavorites) {
        this.numFavorites = numFavorites;
    }

    public long getNumSlides() {
        return this.numSlides;
    }

    public void setNumSlides(long numSlides) {
        this.numSlides = numSlides;
    }

    public List<RelatedSlideshow> getRelatedSlideshows() {
        return this.relatedSlideshows;
    }

    public void setRelatedSlideshows(List<RelatedSlideshow> relatedSlideshows) {
        this.relatedSlideshows = relatedSlideshows;
    }

    public boolean isPrivate() {
        return this.isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public boolean isFlagged() {
        return this.isFlagged;
    }

    public void setFlagged(boolean isFlagged) {
        this.isFlagged = isFlagged;
    }

    public boolean isShowOnSlideShare() {
        return this.showOnSlideShare;
    }

    public void setShowOnSlideShare(boolean showOnSlideShare) {
        this.showOnSlideShare = showOnSlideShare;
    }

    public boolean isSecretUrl() {
        return this.isSecretUrl;
    }

    public void setSecretUrl(boolean isSecretUrl) {
        this.isSecretUrl = isSecretUrl;
    }

    public boolean isAllowEmbed() {
        return this.allowEmbed;
    }

    public void setAllowEmbed(boolean allowEmbed) {
        this.allowEmbed = allowEmbed;
    }

    public boolean isShareWithContacts() {
        return this.shareWithContacts;
    }

    public void setShareWithContacts(boolean shareWithContacts) {
        this.shareWithContacts = shareWithContacts;
    }

    public Integer getThumbnailSizeWidth() {
        return this.getSpecificThumbnailSize("width");
    }

    public Integer getThumbnailSizeHeight() {
        return this.getSpecificThumbnailSize("height");
    }

    private Integer getSpecificThumbnailSize(String groupName) {
        if (this.thumbnailSize == null) {
            return null;
        }
        Matcher matcher = THUMBNAIL_SIZE_PATTERN.matcher(this.thumbnailSize);
        if (matcher.find()) {
            return Integer.valueOf(matcher.group(groupName));
        }
        return null;
    }

    public static class RelatedSlideshow {
        private int rank;
        private String id;

        public int getRank() {
            return this.rank;
        }

        public void setRank(int rank) {
            this.rank = rank;
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }
    }

    public static class Tag {
        private int count;
        private boolean used;
        private String name;

        public int getCount() {
            return this.count;
        }

        public void setCount(int count) {
            this.count = count;
        }

        public boolean isUsed() {
            return this.used;
        }

        public void setUsed(boolean used) {
            this.used = used;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static enum SlideshowType {
        PRESENTATION,
        DOCUMENT,
        PORTFOLIO,
        VIDEO;

    }

    public static enum Status {
        QUEUED,
        CONVERTING,
        CONVERTED,
        FAILED;

    }
}

