/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.slideshare.api.impl;

import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.social.slideshare.api.impl.SlideShareServiceErrorException;
import org.springframework.social.slideshare.api.impl.xml.JacksonUtils;
import org.springframework.social.slideshare.api.impl.xml.SlideShareServiceError;
import org.springframework.social.slideshare.api.impl.xml.SlideShareServiceErrorCode;
import org.springframework.web.client.DefaultResponseErrorHandler;

public class SlideshareErrorHandler
extends DefaultResponseErrorHandler {
    public boolean hasError(ClientHttpResponse response) throws IOException {
        if (super.hasError(response)) {
            return true;
        }
        XmlMapper xmlMapper = JacksonUtils.XML_MAPPER;
        SlideShareServiceError error = (SlideShareServiceError)xmlMapper.readValue(response.getBody(), SlideShareServiceError.class);
        return error != null && error.getMessage() != null;
    }

    public void handleError(ClientHttpResponse response) throws IOException {
        XmlMapper xmlMapper = JacksonUtils.XML_MAPPER;
        SlideShareServiceError error = (SlideShareServiceError)xmlMapper.readValue(response.getBody(), SlideShareServiceError.class);
        SlideShareServiceErrorCode errorCode = error.getErrorCode();
        String message = "SlideShare API returned error response: " + (Object)((Object)errorCode);
        throw new SlideShareServiceErrorException(error.getErrorCode(), message);
    }
}

