/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.social.slideshare.api.impl.xml;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.CreatorCollector;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.social.slideshare.api.domain.GetSlideshowsResponse;
import org.springframework.social.slideshare.api.domain.SearchSlideshowsResponse;
import org.springframework.social.slideshare.api.domain.Slideshow;
import org.springframework.social.slideshare.api.impl.xml.GetSlideshowsResponseMixin;
import org.springframework.social.slideshare.api.impl.xml.SearchSlideshowsResponseMixin;
import org.springframework.social.slideshare.api.impl.xml.SlideShareServiceError;
import org.springframework.social.slideshare.api.impl.xml.SlideShareServiceErrorMixin;
import org.springframework.social.slideshare.api.impl.xml.SlideshowIdHolder;
import org.springframework.social.slideshare.api.impl.xml.SlideshowIdHolderMixin;
import org.springframework.social.slideshare.api.impl.xml.SlideshowMixIn;
import org.springframework.util.StringUtils;

public class JacksonUtils {
    public static XmlMapper XML_MAPPER = JacksonUtils.createXmlMapper();

    private static XmlMapper createXmlMapper() {
        return (XmlMapper)new Jackson2ObjectMapperBuilder().mixIn(Slideshow.class, SlideshowMixIn.class).mixIn(Slideshow.Tag.class, SlideshowMixIn.TagMixin.class).mixIn(Slideshow.RelatedSlideshow.class, SlideshowMixIn.RelatedSlideshowMixin.class).mixIn(GetSlideshowsResponse.class, GetSlideshowsResponseMixin.class).mixIn(SearchSlideshowsResponse.class, SearchSlideshowsResponseMixin.class).mixIn(SearchSlideshowsResponse.MetaInfo.class, SearchSlideshowsResponseMixin.MetaInfoMixin.class).mixIn(SlideshowIdHolder.class, SlideshowIdHolderMixin.class).mixIn(SlideShareServiceError.class, SlideShareServiceErrorMixin.class).mixIn(SlideShareServiceError.Message.class, SlideShareServiceErrorMixin.MessageMixin.class).dateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss zzz")).createXmlMapper(true).build();
    }

    public static <T> T deserializeNodeForCollection(JsonParser jp, DeserializationContext ctxt, JavaType javaType) throws IOException, JsonProcessingException {
        String str;
        if (jp.isExpectedStartArrayToken()) {
            JsonNode jsonNode = (JsonNode)jp.readValueAs(JsonNode.class);
            Object result = XML_MAPPER.reader(javaType).readValue(jsonNode);
            return (T)result;
        }
        if (jp.getCurrentToken() == JsonToken.VALUE_STRING && StringUtils.isEmpty((Object)StringUtils.trimAllWhitespace((String)(str = jp.getText())))) {
            DeserializationConfig config = ctxt.getConfig();
            BeanDescription beanDesc = config.introspect(javaType);
            boolean fixAccess = ctxt.canOverrideAccessModifiers();
            CreatorCollector creators = new CreatorCollector(beanDesc, fixAccess);
            ValueInstantiator valueInstantiator = creators.constructValueInstantiator(config);
            return (T)valueInstantiator.createUsingDefault(ctxt);
        }
        throw ctxt.mappingException("Expected XML element");
    }
}

