/*
 * Decompiled with CFR 0.152.
 */
package net.twibs.web;

import com.google.common.base.Charsets;
import com.google.common.io.ByteStreams;
import java.io.InputStream;
import java.io.OutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.twibs.util.Predef$;
import net.twibs.util.Request;
import net.twibs.web.AsAttachment;
import net.twibs.web.ErrorResponse;
import net.twibs.web.NotFoundResponse;
import net.twibs.web.RedirectResponse;
import net.twibs.web.Response;
import org.threeten.bp.ZonedDateTime;
import org.threeten.bp.temporal.TemporalAmount;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Serializable;
import scala.Some;
import scala.collection.mutable.StringBuilder;
import scala.concurrent.duration.Duration;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0001\u0002\u0001\u0013\t!\u0002\n\u001e;q%\u0016\u001c\bo\u001c8tKJ+g\u000eZ3sKJT!a\u0001\u0003\u0002\u0007],'M\u0003\u0002\u0006\r\u0005)Ao^5cg*\tq!A\u0002oKR\u001c\u0001a\u0005\u0002\u0001\u0015A\u00111BD\u0007\u0002\u0019)\tQ\"A\u0003tG\u0006d\u0017-\u0003\u0002\u0010\u0019\t1\u0011I\\=SK\u001aD\u0001\"\u0005\u0001\u0003\u0002\u0003\u0006IAE\u0001\be\u0016\fX/Z:u!\t\u0019b#D\u0001\u0015\u0015\t)B!\u0001\u0003vi&d\u0017BA\f\u0015\u0005\u001d\u0011V-];fgRD\u0001\"\u0007\u0001\u0003\u0002\u0003\u0006IAG\u0001\te\u0016\u001c\bo\u001c8tKB\u00111\u0004H\u0007\u0002\u0005%\u0011QD\u0001\u0002\t%\u0016\u001c\bo\u001c8tK\"Aq\u0004\u0001B\u0001B\u0003%\u0001%A\u0006iiR\u0004(+Z9vKN$\bCA\u0011)\u001b\u0005\u0011#BA\u0012%\u0003\u0011AG\u000f\u001e9\u000b\u0005\u00152\u0013aB:feZdW\r\u001e\u0006\u0002O\u0005)!.\u0019<bq&\u0011\u0011F\t\u0002\u0013\u0011R$\boU3sm2,GOU3rk\u0016\u001cH\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u00031AG\u000f\u001e9SKN\u0004xN\\:f!\t\tS&\u0003\u0002/E\t\u0019\u0002\n\u001e;q'\u0016\u0014h\u000f\\3u%\u0016\u001c\bo\u001c8tK\")\u0001\u0007\u0001C\u0001c\u00051A(\u001b8jiz\"RAM\u001a5kY\u0002\"a\u0007\u0001\t\u000bEy\u0003\u0019\u0001\n\t\u000bey\u0003\u0019\u0001\u000e\t\u000b}y\u0003\u0019\u0001\u0011\t\u000b-z\u0003\u0019\u0001\u0017\t\u000fa\u0002!\u0019!C\u0005s\u0005y1-\u001e:sK:$H)\u0019;f)&lW-F\u0001;!\tY$)D\u0001=\u0015\tid(\u0001\u0002ca*\u0011q\bQ\u0001\ti\"\u0014X-\u001a;f]*\t\u0011)A\u0002pe\u001eL!a\u0011\u001f\u0003\u001bi{g.\u001a3ECR,G+[7f\u0011\u0019)\u0005\u0001)A\u0005u\u0005\u00012-\u001e:sK:$H)\u0019;f)&lW\r\t\u0005\u0006\u000f\u0002!I!O\u0001\bKb\u0004\u0018N]3t\u0011\u0015I\u0005\u0001\"\u0003K\u00031)\u0007\u0010]5sKN\fe\r^3s+\u0005Y\u0005C\u0001'R\u001b\u0005i%B\u0001(P\u0003!!WO]1uS>t'B\u0001)\r\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003%6\u0013\u0001\u0002R;sCRLwN\u001c\u0005\u0006)\u0002!\t!V\u0001\u0007e\u0016tG-\u001a:\u0015\u0003Y\u0003\"aC,\n\u0005ac!\u0001B+oSRDQA\u0017\u0001\u0005\nm\u000b!B]3eSJ,7\r\u001e+p)\t1F\fC\u0003^3\u0002\u0007a,\u0001\u0004uCJ<W\r\u001e\t\u0003?\nt!a\u00031\n\u0005\u0005d\u0011A\u0002)sK\u0012,g-\u0003\u0002dI\n11\u000b\u001e:j]\u001eT!!\u0019\u0007\t\u000b\u0019\u0004A\u0011B+\u0002\u000fI,7\u000f]8oI\")\u0001\u000e\u0001C\u0005+\u0006AAO]1og\u001a,'\u000fC\u0003k\u0001\u0011%1.\u0001\u0004ti\u0006$Xo\u001d\u000b\u0003Y>\u0004\"aC7\n\u00059d!aA%oi\")\u0011$\u001ba\u00015!)\u0011\u000f\u0001C\u0005e\u0006y\u0011NZ'pI&4\u0017.\u001a3TS:\u001cW-F\u0001t!\tYA/\u0003\u0002v\u0019\t!Aj\u001c8h\u0011\u00159\b\u0001\"\u0003V\u0003=!(/\u00198tM\u0016\u00148i\u001c8uK:$\b")
public class HttpResponseRenderer {
    public final Request net$twibs$web$HttpResponseRenderer$$request;
    private final Response response;
    private final HttpServletRequest httpRequest;
    public final HttpServletResponse net$twibs$web$HttpResponseRenderer$$httpResponse;
    private final ZonedDateTime currentDateTime;

    private ZonedDateTime currentDateTime() {
        return this.currentDateTime;
    }

    private ZonedDateTime expires() {
        return this.currentDateTime().plus((TemporalAmount)Predef$.MODULE$.toThreeTenDuration(this.expiresAfter()));
    }

    private Duration expiresAfter() {
        return this.response.expiresOnClientAfter();
    }

    public void render() {
        Response response = this.response;
        if (response instanceof RedirectResponse) {
            RedirectResponse redirectResponse = (RedirectResponse)response;
            this.redirectTo(redirectResponse.asString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response instanceof NotFoundResponse) {
            this.transfer();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else if (response instanceof ErrorResponse) {
            this.transfer();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            this.respond();
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
    }

    private void redirectTo(String target) {
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.sendRedirect(target);
    }

    private void respond() {
        if (this.response.lastModified() == this.ifModifiedSince()) {
            this.net$twibs$web$HttpResponseRenderer$$httpResponse.setDateHeader("Expires", this.expires().toInstant().toEpochMilli());
            this.net$twibs$web$HttpResponseRenderer$$httpResponse.sendError(304);
        } else {
            this.transfer();
        }
    }

    private void transfer() {
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setStatus(this.status(this.response));
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setHeader("Vary", "Accept-Encoding");
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setDateHeader("Date", this.currentDateTime().toInstant().toEpochMilli());
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setDateHeader("Expires", this.expires().toInstant().toEpochMilli());
        Response response = this.response;
        if (response instanceof AsAttachment) {
            AsAttachment asAttachment = (AsAttachment)response;
            this.net$twibs$web$HttpResponseRenderer$$httpResponse.setHeader("Content-Disposition", new StringBuilder().append((Object)"attachment; filename=\"").append((Object)asAttachment.attachmentFileName()).append((Object)BoxesRunTime.boxToCharacter((char)'\"')).toString());
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        }
        if (this.response.mimeType().startsWith("text/")) {
            this.net$twibs$web$HttpResponseRenderer$$httpResponse.setCharacterEncoding(Charsets.UTF_8.name());
        }
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setContentType(this.response.mimeType());
        this.net$twibs$web$HttpResponseRenderer$$httpResponse.setDateHeader("Last-Modified", this.response.lastModified());
        this.transferContent();
    }

    private int status(Response response) {
        Response response2 = response;
        int n = response2 instanceof RedirectResponse ? 301 : (response2 instanceof NotFoundResponse ? 404 : (response2 instanceof ErrorResponse ? 500 : 200));
        return n;
    }

    private long ifModifiedSince() {
        return this.httpRequest.getDateHeader("If-Modified-Since");
    }

    private void transferContent() {
        Option option;
        block4: {
            block3: {
                Object object;
                block2: {
                    option = this.response.gzippedOption().filter((Function1)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ HttpResponseRenderer $outer;

                        public final boolean apply(byte[] x) {
                            return this.$outer.net$twibs$web$HttpResponseRenderer$$request.doesClientSupportGzipEncoding();
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    });
                    if (!(option instanceof Some)) break block2;
                    Some some = (Some)option;
                    byte[] bytes = (byte[])some.x();
                    this.net$twibs$web$HttpResponseRenderer$$httpResponse.setHeader("Content-Encoding", "gzip");
                    this.net$twibs$web$HttpResponseRenderer$$httpResponse.setContentLength(bytes.length);
                    this.net$twibs$web$HttpResponseRenderer$$httpResponse.getOutputStream().write(bytes);
                    object = BoxedUnit.UNIT;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                this.net$twibs$web$HttpResponseRenderer$$httpResponse.setContentLength((int)this.response.length());
                object = Predef$.MODULE$.toRichClosable((AutoCloseable)this.response.asInputStream()).useAndClose((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ HttpResponseRenderer $outer;

                    public final long apply(InputStream is) {
                        return ByteStreams.copy((InputStream)is, (OutputStream)this.$outer.net$twibs$web$HttpResponseRenderer$$httpResponse.getOutputStream());
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
            }
            this.net$twibs$web$HttpResponseRenderer$$httpResponse.getOutputStream().close();
            return;
        }
        throw new MatchError((Object)option);
    }

    public HttpResponseRenderer(Request request, Response response, HttpServletRequest httpRequest, HttpServletResponse httpResponse) {
        this.net$twibs$web$HttpResponseRenderer$$request = request;
        this.response = response;
        this.httpRequest = httpRequest;
        this.net$twibs$web$HttpResponseRenderer$$httpResponse = httpResponse;
        this.currentDateTime = ZonedDateTime.now();
    }
}

