/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.android;

import com.android.build.gradle.BaseExtension;
import com.android.build.gradle.internal.dsl.BuildType;
import com.android.builder.model.SigningConfig;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.twisterrob.gradle.base.BasePlugin;
import org.gradle.api.NamedDomainObjectCollection;
import org.gradle.api.Project;
import org.gradle.api.plugins.ExtensionContainer;
import org.gradle.kotlin.dsl.ExtensionContainerExtensionsKt;
import org.gradle.kotlin.dsl.NamedDomainObjectCollectionExtensionsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0002J\u0012\u0010\n\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\bH\u0002\u00a8\u0006\f"}, d2={"Lnet/twisterrob/gradle/android/AndroidSigningPlugin;", "Lnet/twisterrob/gradle/base/BasePlugin;", "()V", "apply", "", "target", "Lorg/gradle/api/Project;", "mandatoryProp", "", "name", "optionalProp", "Companion", "twister-convention-plugins"})
public final class AndroidSigningPlugin
extends BasePlugin {
    private static final String SIGNING_CONFIG_NAME = "twisterrob";
    private static final String DEFAULT_STORE_FILE = "twisterrob.jks";
    private static final String STORE_FILE = "RELEASE_STORE_FILE";
    private static final String STORE_PASSWORD = "RELEASE_STORE_PASSWORD";
    private static final String DEFAULT_KEY_ALIAS = "net.twisterrob";
    private static final String KEY_ALIAS = "RELEASE_KEY_ALIAS";
    private static final String KEY_PASSWORD = "RELEASE_KEY_PASSWORD";
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Override
    public void apply(@NotNull Project target) {
        File keyStoreFile;
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        super.apply(target);
        Project project = this.getProject();
        String string = this.optionalProp(STORE_FILE);
        if (string == null) {
            string = DEFAULT_STORE_FILE;
        }
        File file = keyStoreFile = project.file((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"keyStoreFile");
        if (file.isFile() && keyStoreFile.exists() && keyStoreFile.canRead()) {
            this.getLOG().info("Attaching release.signingConfig.{} using '{}'", (Object)SIGNING_CONFIG_NAME, (Object)keyStoreFile);
            ExtensionContainer extensionContainer = this.getProject().getExtensions();
            Intrinsics.checkNotNullExpressionValue((Object)extensionContainer, (String)"project.extensions");
            Object object = ExtensionContainerExtensionsKt.get((ExtensionContainer)extensionContainer, (String)"android");
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.android.build.gradle.BaseExtension");
            }
            BaseExtension android2 = (BaseExtension)object;
            com.android.build.gradle.internal.dsl.SigningConfig signingConfig = new com.android.build.gradle.internal.dsl.SigningConfig(SIGNING_CONFIG_NAME);
            boolean bl = false;
            boolean bl2 = false;
            com.android.build.gradle.internal.dsl.SigningConfig $this$apply = signingConfig;
            boolean bl3 = false;
            $this$apply.setStoreFile(keyStoreFile);
            $this$apply.setStorePassword(this.mandatoryProp(STORE_PASSWORD));
            String string2 = this.optionalProp(KEY_ALIAS);
            if (string2 == null) {
                string2 = DEFAULT_KEY_ALIAS;
            }
            $this$apply.setKeyAlias(string2);
            $this$apply.setKeyPassword(this.mandatoryProp(KEY_PASSWORD));
            com.android.build.gradle.internal.dsl.SigningConfig sign = signingConfig;
            ((BuildType)NamedDomainObjectCollectionExtensionsKt.get((NamedDomainObjectCollection)((NamedDomainObjectCollection)android2.getBuildTypes()), (String)"release")).setSigningConfig((SigningConfig)sign);
        } else if (this.getProject().hasProperty(STORE_FILE)) {
            this.getLOG().error("Keystore file (from {}) '{}' is not valid.", (Object)STORE_FILE, (Object)keyStoreFile.getAbsolutePath());
        }
    }

    private final String optionalProp(String name) {
        return (String)this.getProject().getProperties().get(name);
    }

    private final String mandatoryProp(String name) {
        String string = this.optionalProp(name);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lnet/twisterrob/gradle/android/AndroidSigningPlugin$Companion;", "", "()V", "DEFAULT_KEY_ALIAS", "", "DEFAULT_STORE_FILE", "KEY_ALIAS", "KEY_PASSWORD", "SIGNING_CONFIG_NAME", "STORE_FILE", "STORE_PASSWORD", "twister-convention-plugins"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

