/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.checkstyle;

import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import net.twisterrob.gradle.common.TargetChecker;
import org.gradle.api.Project;
import org.gradle.api.file.FileCollection;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.tasks.Input;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0002R\u001e\u0010\u0004\u001a\u00020\u00058\u0016@\u0016X\u0097\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Lnet/twisterrob/gradle/checkstyle/CheckStyleTask;", "Lorg/gradle/api/plugins/quality/Checkstyle;", "Lnet/twisterrob/gradle/common/TargetChecker;", "()V", "checkTargetName", "", "getCheckTargetName", "()Ljava/lang/String;", "setCheckTargetName", "(Ljava/lang/String;)V", "setupProperties", "", "twister-quality-checkstyle"})
public class CheckStyleTask
extends Checkstyle
implements TargetChecker {
    @Input
    @NotNull
    private String checkTargetName = "*";

    @NotNull
    public String getCheckTargetName() {
        return this.checkTargetName;
    }

    public void setCheckTargetName(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.checkTargetName = string;
    }

    private final void setupProperties() {
        Map map = this.getConfigProperties();
        if (map == null) {
            map = MapsKt.emptyMap();
        }
        Pair[] pairArray = new Pair[3];
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        pairArray[0] = TuplesKt.to((Object)"basedir", (Object)project.getProjectDir());
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        pairArray[1] = TuplesKt.to((Object)"project_loc", (Object)project2.getRootDir());
        Project project3 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project3, (String)"project");
        pairArray[2] = TuplesKt.to((Object)"workspace_loc", (Object)project3.getRootDir());
        this.setConfigProperties(MapsKt.plus((Map)map, (Map)MapsKt.mapOf((Pair[])pairArray)));
    }

    public CheckStyleTask() {
        this.setGroup("verification");
        this.setClasspath((FileCollection)this.getProject().files(new Object[0]));
        this.setShowViolations(false);
        this.setupProperties();
    }
}

