/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.checkstyle;

import java.io.File;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.twisterrob.gradle.checkstyle.CheckStyleExtension;
import net.twisterrob.gradle.checkstyle.CheckStyleTask;
import net.twisterrob.gradle.checkstyle.CheckStyleTaskCreatorKt;
import net.twisterrob.gradle.common.VariantTaskCreator;
import org.gradle.api.Action;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.plugins.quality.Checkstyle;
import org.gradle.api.plugins.quality.CheckstyleReports;
import org.gradle.api.provider.Provider;
import org.gradle.api.reporting.CustomizableHtmlReport;
import org.gradle.api.resources.ResourceHandler;
import org.gradle.api.tasks.SourceTask;
import org.gradle.util.GradleVersion;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J\u0012\u0010\u0006\u001a\f0\u0007R\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0016\u00a8\u0006\b"}, d2={"Lnet/twisterrob/gradle/checkstyle/CheckStyleTaskCreator;", "Lnet/twisterrob/gradle/common/VariantTaskCreator;", "Lnet/twisterrob/gradle/checkstyle/CheckStyleTask;", "project", "Lorg/gradle/api/Project;", "(Lorg/gradle/api/Project;)V", "taskConfigurator", "Lnet/twisterrob/gradle/common/VariantTaskCreator$DefaultTaskConfig;", "twister-quality-checkstyle"})
public final class CheckStyleTaskCreator
extends VariantTaskCreator<CheckStyleTask> {
    @NotNull
    public VariantTaskCreator.DefaultTaskConfig taskConfigurator() {
        return new VariantTaskCreator.DefaultTaskConfig(this){
            final /* synthetic */ CheckStyleTaskCreator this$0;

            public void setupConfigLocations(@NotNull CheckStyleTask task) {
                Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
                File subConfig = task.getProject().file((Object)"config/checkstyle/checkstyle.xml");
                Project project = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
                File rootConfig = project.getRootProject().file((Object)"config/checkstyle/checkstyle.xml");
                if (!task.getConfigFile().exists() || subConfig.exists() && rootConfig.exists()) {
                    if (!subConfig.exists() && !rootConfig.exists()) {
                        task.doFirst("Warn about missing configuration files.", (Action)new Action<Task>(task, rootConfig, subConfig){
                            final /* synthetic */ CheckStyleTask $task;
                            final /* synthetic */ File $rootConfig;
                            final /* synthetic */ File $subConfig;

                            public final void execute(Task it) {
                                this.$task.getLogger().warn(StringsKt.trimIndent((String)("\n\t\t\t\t\t\t\t\tWhile auto-configuring configFile for " + (Object)((Object)this.$task) + ", there was no configuration found at:\n\t\t\t\t\t\t\t\t\trootProject=" + this.$rootConfig + "\n\t\t\t\t\t\t\t\t\tsubProject=" + this.$subConfig + "\n\t\t\t\t\t\t\t\t\ttask=" + this.$task.getConfigFile() + "\n\t\t\t\t\t\t\t\t\tand there's no configuration location set in Gradle build files either.\n\t\t\t\t\t\t\t\t")));
                            }
                            {
                                this.$task = checkStyleTask;
                                this.$rootConfig = file;
                                this.$subConfig = file2;
                            }
                        });
                    }
                    if (subConfig.exists()) {
                        task.setConfigFile(subConfig);
                    } else if (rootConfig.exists()) {
                        task.setConfigFile(rootConfig);
                    }
                }
                GradleVersion gradleVersion = GradleVersion.current();
                Intrinsics.checkNotNullExpressionValue((Object)gradleVersion, (String)"GradleVersion.current()");
                if (gradleVersion.getBaseVersion().compareTo(GradleVersion.version((String)"6.0")) < 0) {
                    Checkstyle checkstyle = task;
                    Provider provider = task.getProject().provider((Callable)new Callable<File>(task){
                        final /* synthetic */ CheckStyleTask $task;

                        public final File call() {
                            File file = this.$task.getConfigFile();
                            Intrinsics.checkNotNullExpressionValue((Object)file, (String)"task.configFile");
                            return file.getParentFile();
                        }
                        {
                            this.$task = checkStyleTask;
                        }
                    });
                    Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"task.project.provider { \u2026k.configFile.parentFile }");
                    CheckStyleTaskCreatorKt.access$setConfigDir(checkstyle, provider);
                } else {
                    DirectoryProperty directoryProperty = task.getConfigDirectory();
                    File file = task.getConfigFile();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"task.configFile");
                    directoryProperty.set(file.getParentFile());
                }
            }

            public void setupReports(@NotNull CheckStyleTask task, @Nullable String suffix) {
                Intrinsics.checkNotNullParameter((Object)((Object)task), (String)"task");
                super.setupReports((SourceTask)task, suffix);
                CheckstyleReports checkstyleReports = task.getReports();
                Intrinsics.checkNotNullExpressionValue((Object)checkstyleReports, (String)"task.reports");
                CustomizableHtmlReport customizableHtmlReport = CheckStyleTaskCreatorKt.access$getCustomHtml$p(checkstyleReports);
                boolean bl = false;
                boolean bl2 = false;
                CustomizableHtmlReport $this$with = customizableHtmlReport;
                boolean bl3 = false;
                Project project = task.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"task.project");
                File xsl = project.getRootProject().file((Object)"config/checkstyle/checkstyle-html.xsl");
                if (xsl.exists()) {
                    Project project2 = task.getProject();
                    Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"task.project");
                    ResourceHandler resourceHandler = project2.getResources();
                    Intrinsics.checkNotNullExpressionValue((Object)resourceHandler, (String)"task.project.resources");
                    $this$with.setStylesheet(resourceHandler.getText().fromFile((Object)xsl));
                }
            }
            {
                this.this$0 = this$0;
                super((VariantTaskCreator)this$0);
            }
        };
    }

    public CheckStyleTaskCreator(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project, "checkstyle", "checkstyle", CheckStyleTask.class, CheckStyleExtension.class);
    }
}

