/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.common;

import kotlin.Metadata;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import net.twisterrob.gradle.common.AGPVersion$compareTo$1;
import net.twisterrob.gradle.common.AGPVersion$compareTo$2;
import net.twisterrob.gradle.common.AGPVersion$compareTo$3;
import net.twisterrob.gradle.common.AGPVersion$compareTo$4;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\b\u0018\u0000  2\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0002 !B+\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\bJ\u0011\u0010\u0011\u001a\u00020\u00032\u0006\u0010\u0012\u001a\u00020\u0000H\u0096\u0002J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0000H\u0086\u0004J\t\u0010\u0015\u001a\u00020\u0003H\u00c6\u0003J\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0017\u001a\u0004\u0018\u00010\u0006H\u00c6\u0003J\u0010\u0010\u0018\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ<\u0010\u0019\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0005\u001a\u0004\u0018\u00010\u00062\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001\u00a2\u0006\u0002\u0010\u001aJ\u0013\u0010\u001b\u001a\u00020\u00142\b\u0010\u0012\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u001e\u001a\u00020\u001fH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0015\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\fR\u0015\u0010\u0007\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000e\u0010\fR\u0013\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\""}, d2={"Lnet/twisterrob/gradle/common/AGPVersion;", "", "major", "", "minor", "type", "Lnet/twisterrob/gradle/common/AGPVersion$ReleaseType;", "patch", "(ILjava/lang/Integer;Lnet/twisterrob/gradle/common/AGPVersion$ReleaseType;Ljava/lang/Integer;)V", "getMajor", "()I", "getMinor", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "getPatch", "getType", "()Lnet/twisterrob/gradle/common/AGPVersion$ReleaseType;", "compareTo", "other", "compatible", "", "component1", "component2", "component3", "component4", "copy", "(ILjava/lang/Integer;Lnet/twisterrob/gradle/common/AGPVersion$ReleaseType;Ljava/lang/Integer;)Lnet/twisterrob/gradle/common/AGPVersion;", "equals", "", "hashCode", "toString", "", "Companion", "ReleaseType", "twister-quality-common"})
public final class AGPVersion
implements Comparable<AGPVersion> {
    private final int major;
    @Nullable
    private final Integer minor;
    @Nullable
    private final ReleaseType type;
    @Nullable
    private final Integer patch;
    private static final Regex AGP_VERSION_REGEX;
    @NotNull
    public static final Companion Companion;

    public final boolean compatible(@NotNull AGPVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        boolean bl = other.minor == null || other.type == null || other.patch == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = other + " must be a joker.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.major != other.major) {
            return false;
        }
        if (other.minor != null && Intrinsics.areEqual((Object)this.minor, (Object)other.minor) ^ true) {
            return false;
        }
        if (other.type != null && this.type != other.type) {
            return false;
        }
        return other.patch == null || !(Intrinsics.areEqual((Object)this.patch, (Object)other.patch) ^ true);
    }

    @NotNull
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder().append(this.major).append('.');
        Object object = this.minor;
        if (object == null) {
            object = "*";
        }
        StringBuilder stringBuilder2 = stringBuilder.append(object).append('.');
        Object object2 = this.type;
        if (object2 == null) {
            object2 = "*";
        }
        StringBuilder stringBuilder3 = stringBuilder2.append(object2).append('.');
        Object object3 = this.patch;
        if (object3 == null) {
            object3 = "*";
        }
        return stringBuilder3.append(object3).toString();
    }

    @Override
    public int compareTo(@NotNull AGPVersion other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return ComparisonsKt.compareValuesBy((Object)this, (Object)other, (Function1[])new Function1[]{(Function1)AGPVersion$compareTo$1.INSTANCE, (Function1)AGPVersion$compareTo$2.INSTANCE, (Function1)AGPVersion$compareTo$3.INSTANCE, (Function1)AGPVersion$compareTo$4.INSTANCE});
    }

    public final int getMajor() {
        return this.major;
    }

    @Nullable
    public final Integer getMinor() {
        return this.minor;
    }

    @Nullable
    public final ReleaseType getType() {
        return this.type;
    }

    @Nullable
    public final Integer getPatch() {
        return this.patch;
    }

    public AGPVersion(int major, @Nullable Integer minor, @Nullable ReleaseType type, @Nullable Integer patch) {
        this.major = major;
        this.minor = minor;
        this.type = type;
        this.patch = patch;
        boolean bl = this.major >= 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Integer n = this.minor;
        bl = (n != null ? n : 0) >= 0;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl6 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        Integer n2 = this.patch;
        bl = (n2 != null ? n2 : 0) >= 0;
        bl2 = false;
        bl3 = false;
        bl3 = false;
        bl4 = false;
        if (!bl) {
            boolean bl7 = false;
            String string = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (this.patch != null) {
            ReleaseType releaseType = this.type;
            bl2 = false;
            bl3 = false;
            if (releaseType == null) {
                boolean bl8 = false;
                String string = "If a patch release is given, you must specify its type.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        if (this.patch != null) {
            Integer n3 = this.minor;
            bl2 = false;
            bl3 = false;
            if (n3 == null) {
                boolean bl9 = false;
                String string = "Cannot specify a patch version without minor.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
        if (this.type != null) {
            Integer n4 = this.minor;
            bl2 = false;
            bl3 = false;
            if (n4 == null) {
                boolean bl10 = false;
                String string = "Cannot specify a release type without minor.";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }
    }

    static {
        Companion = new Companion(null);
        String string = "^(?<major>\\d+)(?:\\.(?<minor>\\d+)(?:\\.(?<patch>\\d+))?(?:-(?<type>alpha|beta|rc)(?<iteration>\\d+))?)?$";
        boolean bl = false;
        AGP_VERSION_REGEX = new Regex(string);
    }

    public final int component1() {
        return this.major;
    }

    @Nullable
    public final Integer component2() {
        return this.minor;
    }

    @Nullable
    public final ReleaseType component3() {
        return this.type;
    }

    @Nullable
    public final Integer component4() {
        return this.patch;
    }

    @NotNull
    public final AGPVersion copy(int major, @Nullable Integer minor, @Nullable ReleaseType type, @Nullable Integer patch) {
        return new AGPVersion(major, minor, type, patch);
    }

    public static /* synthetic */ AGPVersion copy$default(AGPVersion aGPVersion, int n, Integer n2, ReleaseType releaseType, Integer n3, int n4, Object object) {
        if ((n4 & 1) != 0) {
            n = aGPVersion.major;
        }
        if ((n4 & 2) != 0) {
            n2 = aGPVersion.minor;
        }
        if ((n4 & 4) != 0) {
            releaseType = aGPVersion.type;
        }
        if ((n4 & 8) != 0) {
            n3 = aGPVersion.patch;
        }
        return aGPVersion.copy(n, n2, releaseType, n3);
    }

    public int hashCode() {
        Integer n = this.minor;
        ReleaseType releaseType = this.type;
        Integer n2 = this.patch;
        return ((Integer.hashCode(this.major) * 31 + (n != null ? ((Object)n).hashCode() : 0)) * 31 + (releaseType != null ? releaseType.hashCode() : 0)) * 31 + (n2 != null ? ((Object)n2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AGPVersion)) break block3;
                AGPVersion aGPVersion = (AGPVersion)object;
                if (this.major != aGPVersion.major || !Intrinsics.areEqual((Object)this.minor, (Object)aGPVersion.minor) || !Intrinsics.areEqual((Object)this.type, (Object)aGPVersion.type) || !Intrinsics.areEqual((Object)this.patch, (Object)aGPVersion.patch)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\u0010\u000f\n\u0002\b\u0006\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007\u00a8\u0006\b"}, d2={"Lnet/twisterrob/gradle/common/AGPVersion$ReleaseType;", "", "", "(Ljava/lang/String;I)V", "Alpha", "Beta", "Candidate", "Stable", "twister-quality-common"})
    public static final class ReleaseType
    extends Enum<ReleaseType>
    implements Comparable<ReleaseType> {
        public static final /* enum */ ReleaseType Alpha;
        public static final /* enum */ ReleaseType Beta;
        public static final /* enum */ ReleaseType Candidate;
        public static final /* enum */ ReleaseType Stable;
        private static final /* synthetic */ ReleaseType[] $VALUES;

        static {
            ReleaseType[] releaseTypeArray = new ReleaseType[4];
            ReleaseType[] releaseTypeArray2 = releaseTypeArray;
            releaseTypeArray[0] = Alpha = new ReleaseType();
            releaseTypeArray[1] = Beta = new ReleaseType();
            releaseTypeArray[2] = Candidate = new ReleaseType();
            releaseTypeArray[3] = Stable = new ReleaseType();
            $VALUES = releaseTypeArray;
        }

        public static ReleaseType[] values() {
            return (ReleaseType[])$VALUES.clone();
        }

        public static ReleaseType valueOf(String string) {
            return Enum.valueOf(ReleaseType.class, string);
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\t"}, d2={"Lnet/twisterrob/gradle/common/AGPVersion$Companion;", "", "()V", "AGP_VERSION_REGEX", "Lkotlin/text/Regex;", "parse", "Lnet/twisterrob/gradle/common/AGPVersion;", "version", "", "twister-quality-common"})
    public static final class Companion {
        /*
         * Recovered potentially malformed switches.  Disable with '--allowmalformedswitch false'
         * WARNING - void declaration
         * Enabled aggressive block sorting
         */
        @NotNull
        public final AGPVersion parse(@NotNull String version) {
            ReleaseType releaseType;
            String string;
            Integer iteration;
            Integer n;
            boolean bl;
            Object object;
            Integer patch;
            Integer n2;
            Object object2;
            Integer minor;
            Integer n3;
            Intrinsics.checkNotNullParameter((Object)version, (String)"version");
            MatchResult matchResult = AGP_VERSION_REGEX.matchEntire((CharSequence)version);
            if (matchResult == null) {
                String string2 = "Unrecognised Android Gradle Plugin version: " + version + ", only " + AGP_VERSION_REGEX + " are supported.";
                boolean bl2 = false;
                throw (Throwable)new IllegalStateException(string2.toString());
            }
            MatchResult match = matchResult;
            MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"major");
            Intrinsics.checkNotNull((Object)matchGroup);
            String string3 = matchGroup.getValue();
            boolean bl3 = false;
            int major = Integer.parseInt(string3);
            Object object3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"minor");
            if (object3 != null && (object3 = object3.getValue()) != null) {
                Object object4 = object3;
                boolean bl4 = false;
                n3 = Integer.parseInt((String)object4);
            } else {
                n3 = minor = null;
            }
            if ((object2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"patch")) != null && (object2 = object2.getValue()) != null) {
                Object object5 = object2;
                boolean bl5 = false;
                n2 = Integer.parseInt((String)object5);
            } else {
                n2 = patch = null;
            }
            if ((object = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"iteration")) != null && (object = object.getValue()) != null && (object = StringsKt.trimStart((String)object, (char[])new char[]{'0'})) != null) {
                Object object6 = object;
                bl = false;
                n = Integer.parseInt((String)object6);
            } else {
                n = iteration = null;
            }
            if (iteration != null) {
                Integer n4 = patch;
                if (n4 == null || n4 != 0) {
                    String string4 = "Invalid version, pattern: <major>.<minor>.<patch>-<type><iteration> is not supported with patch other than 0.";
                    bl = false;
                    throw (Throwable)new IllegalStateException(string4.toString());
                }
            }
            MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)match.getGroups(), (String)"type");
            String string5 = string = matchGroup2 != null ? matchGroup2.getValue() : null;
            if (string5 == null) {
                releaseType = ReleaseType.Stable;
            } else {
                switch (string5) {
                    case "alpha": {
                        releaseType = ReleaseType.Alpha;
                        break;
                    }
                    case "beta": {
                        releaseType = ReleaseType.Beta;
                        break;
                    }
                    case "rc": {
                        releaseType = ReleaseType.Candidate;
                        break;
                    }
                    default: {
                        void preReleaseTypeString;
                        String string6 = "Unknown " + (String)preReleaseTypeString;
                        boolean bl6 = false;
                        throw (Throwable)new IllegalStateException(string6.toString());
                    }
                }
            }
            ReleaseType type = releaseType;
            Integer n5 = iteration;
            if (n5 != null) {
                return new AGPVersion(major, minor, type, n5);
            }
            n5 = patch;
            return new AGPVersion(major, minor, type, n5);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

