/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.common;

import com.android.build.gradle.internal.tasks.AndroidVariantTask;
import com.android.build.gradle.internal.tasks.VariantAwareTask;
import com.android.build.gradle.tasks.LintBaseTask;
import com.android.build.gradle.tasks.LintFixTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import java.io.File;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import net.twisterrob.gradle.common.AGPVersions;
import net.twisterrob.gradle.common.Utils;
import net.twisterrob.gradle.common.Utils$sam$java_io_FileFilter$0;
import net.twisterrob.gradle.common.Utils$sam$java_util_function_BinaryOperator$0;
import org.gradle.StartParameter;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.invocation.Gradle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=2, d1={"\u0000Z\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a2\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u001c\u001a\u00020\u00012\b\u0010\u000e\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u001d\u001a\u00020\n\u001a\u001a\u0010\u001e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010 \u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\u001a8\u0010\u001e\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u0001H!\u0012\u0002\b\u0003\u0012\u0006\u0012\u0004\u0018\u00010 0\u001f\"\u0004\b\u0000\u0010!2\u0016\u0010\"\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u0001H!\u0012\u0006\u0012\u0004\u0018\u00010 0#\u001a!\u0010$\u001a\u0004\u0018\u00010 2\b\u0010%\u001a\u0004\u0018\u00010 2\b\u0010&\u001a\u0004\u0018\u00010 \u00a2\u0006\u0002\u0010'\u001a-\u0010(\u001a\b\u0012\u0004\u0012\u00020\u00060)*\u00020\u00062\u0016\b\u0002\u0010*\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\n\u0018\u00010+\u00a2\u0006\u0002\u0010,\"\u0017\u0010\u0000\u001a\u0004\u0018\u00010\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0015\u0010\u0005\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u001e\u0010\t\u001a\u00020\n*\u00020\u00028BX\u0082\u0004\u00a2\u0006\f\u0012\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\r\"\u0018\u0010\u000e\u001a\u00020\u0006*\u00020\u00028BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\b\"\u0015\u0010\u0010\u001a\u00020\n*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\u0013\"\u0015\u0010\u0014\u001a\u00020\n*\u00020\u00118F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0013\"\u0015\u0010\u0016\u001a\u00020\u0006*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\b*\u001a\u0010-\"\n\u0012\u0006\b\u0001\u0012\u00020/0.2\n\u0012\u0006\b\u0001\u0012\u00020/0.\u00a8\u00060"}, d2={"androidVariantName", "", "Lcom/android/build/gradle/tasks/LintBaseTask;", "getAndroidVariantName", "(Lcom/android/build/gradle/tasks/LintBaseTask;)Ljava/lang/String;", "htmlOutput", "Ljava/io/File;", "getHtmlOutput", "(Lcom/android/build/gradle/tasks/LintBaseTask;)Ljava/io/File;", "isFatalOnly", "", "isFatalOnly$annotations", "(Lcom/android/build/gradle/tasks/LintBaseTask;)V", "(Lcom/android/build/gradle/tasks/LintBaseTask;)Z", "reportsDir", "getReportsDir", "wasLaunchedExplicitly", "Lorg/gradle/api/Task;", "getWasLaunchedExplicitly", "(Lorg/gradle/api/Task;)Z", "wasLaunchedOnly", "getWasLaunchedOnly", "xmlOutput", "getXmlOutput", "LintOptions_createOutputPath", "project", "Lorg/gradle/api/Project;", "variantName", "extension", "fatalOnly", "nullSafeSum", "Ljava/util/stream/Collector;", "", "T", "mapper", "Ljava/util/function/Function;", "safeAdd", "a", "b", "(Ljava/lang/Integer;Ljava/lang/Integer;)Ljava/lang/Integer;", "listFilesInDirectory", "", "filter", "Lkotlin/Function1;", "(Ljava/io/File;Lkotlin/jvm/functions/Function1;)[Ljava/io/File;", "Variants", "Lorg/gradle/api/DomainObjectSet;", "Lcom/android/build/gradle/api/BaseVariant;", "twister-quality-common"})
@JvmName(name="Utils")
public final class Utils {
    @Nullable
    public static final Integer safeAdd(@Nullable Integer a, @Nullable Integer b) {
        Integer n;
        if (a != null && b != null) {
            n = a + b;
        } else if (a != null && b == null) {
            n = a;
        } else if (a == null && b != null) {
            n = b;
        } else if (a == null && b == null) {
            n = null;
        } else {
            throw (Throwable)new InternalError("No other possibility");
        }
        return n;
    }

    @NotNull
    public static final Collector<Integer, ?, Integer> nullSafeSum() {
        Function function = Function.identity();
        Intrinsics.checkNotNullExpressionValue(function, (String)"Function.identity()");
        return Utils.nullSafeSum(function);
    }

    @NotNull
    public static final <T> Collector<T, ?, Integer> nullSafeSum(@NotNull Function<T, Integer> mapper) {
        Intrinsics.checkNotNullParameter(mapper, (String)"mapper");
        Object object = nullSafeSum.1.INSTANCE;
        if (object != null) {
            Function2 function2 = object;
            object = new Utils$sam$java_util_function_BinaryOperator$0(function2);
        }
        Collector<T, ?, Integer> collector = Collectors.reducing(null, mapper, (BinaryOperator)object);
        Intrinsics.checkNotNullExpressionValue(collector, (String)"Collectors.reducing(null\u2026inaryOperator(::safeAdd))");
        return collector;
    }

    @NotNull
    public static final File[] listFilesInDirectory(@NotNull File $this$listFilesInDirectory, @Nullable Function1<? super File, Boolean> filter) {
        File[] listFiles;
        File[] fileArray;
        Object object;
        Intrinsics.checkNotNullParameter((Object)$this$listFilesInDirectory, (String)"$this$listFilesInDirectory");
        if (filter != null) {
            object = filter;
            fileArray = $this$listFilesInDirectory.listFiles(new Utils$sam$java_io_FileFilter$0((Function1)object));
        } else {
            fileArray = $this$listFilesInDirectory.listFiles();
        }
        if (listFiles == null) {
            object = $this$listFilesInDirectory + " does not denote a directory or an error occurred" + "\nisDirectory=" + $this$listFilesInDirectory.isDirectory() + ", exists=" + $this$listFilesInDirectory.exists() + ", canRead=" + $this$listFilesInDirectory.canRead();
            boolean bl = false;
            throw (Throwable)new IllegalStateException(object.toString());
        }
        listFiles = fileArray;
        return listFiles;
    }

    public static /* synthetic */ File[] listFilesInDirectory$default(File file, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            function1 = null;
        }
        return Utils.listFilesInDirectory(file, (Function1<? super File, Boolean>)function1);
    }

    public static final boolean getWasLaunchedOnly(@NotNull Task $this$wasLaunchedOnly) {
        Intrinsics.checkNotNullParameter((Object)$this$wasLaunchedOnly, (String)"$this$wasLaunchedOnly");
        Project project = $this$wasLaunchedOnly.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkNotNullExpressionValue((Object)startParameter, (String)"project.gradle.startParameter");
        return Intrinsics.areEqual((Object)startParameter.getTaskNames(), (Object)CollectionsKt.listOf((Object)$this$wasLaunchedOnly.getPath()));
    }

    public static final boolean getWasLaunchedExplicitly(@NotNull Task $this$wasLaunchedExplicitly) {
        Intrinsics.checkNotNullParameter((Object)$this$wasLaunchedExplicitly, (String)"$this$wasLaunchedExplicitly");
        Project project = $this$wasLaunchedExplicitly.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        StartParameter startParameter = gradle.getStartParameter();
        Intrinsics.checkNotNullExpressionValue((Object)startParameter, (String)"project.gradle.startParameter");
        return startParameter.getTaskNames().contains($this$wasLaunchedExplicitly.getPath());
    }

    private static final File getReportsDir(LintBaseTask $this$reportsDir) {
        Project project = $this$reportsDir.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        File file = project.getBuildDir();
        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"project.buildDir");
        return FilesKt.resolve((File)file, (String)"reports");
    }

    private static /* synthetic */ void isFatalOnly$annotations(LintBaseTask lintBaseTask) {
    }

    private static final boolean isFatalOnly(LintBaseTask $this$isFatalOnly) {
        return false;
    }

    @Nullable
    public static final String getAndroidVariantName(@NotNull LintBaseTask $this$androidVariantName) {
        Intrinsics.checkNotNullParameter((Object)$this$androidVariantName, (String)"$this$androidVariantName");
        return AGPVersions.INSTANCE.getV33x().compareTo(AGPVersions.INSTANCE.getCLASSPATH()) < 0 && $this$androidVariantName instanceof VariantAwareTask ? ((VariantAwareTask)$this$androidVariantName).getVariantName() : (AGPVersions.INSTANCE.getCLASSPATH().compareTo(AGPVersions.INSTANCE.getV33x()) < 0 && $this$androidVariantName instanceof AndroidVariantTask ? ((AndroidVariantTask)$this$androidVariantName).getVariantName() : ($this$androidVariantName instanceof LintGlobalTask ? null : (AGPVersions.INSTANCE.getV32x().compareTo(AGPVersions.INSTANCE.getCLASSPATH()) < 0 && $this$androidVariantName instanceof LintFixTask ? null : null)));
    }

    @NotNull
    public static final File getXmlOutput(@NotNull LintBaseTask $this$xmlOutput) {
        Intrinsics.checkNotNullParameter((Object)$this$xmlOutput, (String)"$this$xmlOutput");
        File file = $this$xmlOutput.getLintOptions().getXmlOutput();
        if (file == null) {
            Project project = $this$xmlOutput.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            file = Utils.LintOptions_createOutputPath(project, Utils.getAndroidVariantName($this$xmlOutput), ".xml", Utils.getReportsDir($this$xmlOutput), Utils.isFatalOnly($this$xmlOutput));
        }
        return file;
    }

    @NotNull
    public static final File getHtmlOutput(@NotNull LintBaseTask $this$htmlOutput) {
        Intrinsics.checkNotNullParameter((Object)$this$htmlOutput, (String)"$this$htmlOutput");
        File file = $this$htmlOutput.getLintOptions().getHtmlOutput();
        if (file == null) {
            Project project = $this$htmlOutput.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
            file = Utils.LintOptions_createOutputPath(project, Utils.getAndroidVariantName($this$htmlOutput), ".html", Utils.getReportsDir($this$htmlOutput), Utils.isFatalOnly($this$htmlOutput));
        }
        return file;
    }

    @NotNull
    public static final File LintOptions_createOutputPath(@NotNull Project project, @Nullable String variantName, @NotNull String extension, @Nullable File reportsDir, boolean fatalOnly) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = false;
        boolean bl2 = false;
        StringBuilder $this$apply = stringBuilder;
        boolean bl3 = false;
        $this$apply.append("lint-results");
        CharSequence charSequence = variantName;
        boolean bl4 = false;
        boolean bl5 = false;
        if (!(charSequence == null || charSequence.length() == 0)) {
            $this$apply.append("-");
            $this$apply.append(variantName);
        }
        if (fatalOnly) {
            $this$apply.append("-fatal");
        }
        $this$apply.append(extension);
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply {\n\u2026(extension)\n\t}.toString()");
        String base = string;
        return reportsDir != null ? new File(reportsDir, base) : new File(project.getBuildDir(), "reports" + File.separator + base);
    }
}

