/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.common.grouper;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.twisterrob.gradle.common.grouper.AbstractGrouper;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.NullObject;

public class Grouper<K, V>
extends AbstractGrouper {
    @Nonnull
    private final List<String> fields;

    @Nonnull
    public static <T> Start<T> create(@Nonnull List<T> list) {
        return Grouper.create(list, Collectors.reducing(0, e -> 1, Integer::sum));
    }

    @Nonnull
    public static <T> Start<T> create(@Nonnull List<T> list, @Nonnull Collector<T, ?, ?> finalCollector) {
        return new Start(Collections.unmodifiableList(list), Grouper.findRepresentative(list), finalCollector);
    }

    private Grouper(@Nonnull List<?> list, @Nonnull Object representative, @Nonnull List<String> fields, @Nonnull Collector<?, ?, ?> finalCollector) {
        super(list, representative, finalCollector);
        this.fields = fields;
    }

    @Nonnull
    public Grouper<K, Map<?, V>> by(@Nonnull String fieldName) {
        return new Grouper<K, V>(this.list, this.representative, DefaultGroovyMethods.plus(this.fields, (Object)fieldName), this.finalCollector);
    }

    @Nonnull
    public Grouper<K, Map<?, V>> getAt(@Nonnull String fieldName) {
        return super.getAt(fieldName);
    }

    @Override
    public Object getProperty(String fieldName) {
        return super.getProperty(fieldName);
    }

    @Nonnull
    public Map<K, V> group() {
        ArrayList<String> reversed = new ArrayList<String>(this.fields);
        Collections.reverse(reversed);
        Collector<Object, ?, LinkedHashMap> collectors = this.finalCollector;
        for (String field : reversed) {
            Function<Object, Object> access = obj -> DefaultGroovyMethods.getAt((Object)obj, (String)field);
            collectors = Collectors.groupingBy(access, LinkedHashMap::new, collectors);
        }
        return (Map)this.list.stream().collect(collectors);
    }

    public String toString() {
        return String.format("%d %s grouped on %s", this.list.size(), this.representative.getClass(), this.fields);
    }

    private static Object findRepresentative(@Nonnull Collection<?> list) {
        Object found = DefaultGroovyMethods.find(list);
        if (found != null) {
            return found;
        }
        return NullObject.getNullObject();
    }

    public static class Counter<T, R>
    extends AbstractGrouper {
        private Counter(@Nonnull List<T> list, @Nonnull Object representative, @Nonnull Collector<T, ?, R> finalCollector) {
            super(list, representative, finalCollector);
        }

        @Nonnull
        public Grouper<?, R> by(@Nonnull String fieldName) {
            return new Grouper(this.list, this.representative, Collections.singletonList(fieldName), this.finalCollector);
        }

        @Nonnull
        public Grouper<?, R> getAt(@Nonnull String fieldName) {
            return super.getAt(fieldName);
        }

        @Override
        public Object getProperty(String fieldName) {
            return super.getProperty(fieldName);
        }
    }

    public static class Start<T>
    extends AbstractGrouper {
        private Start(@Nonnull List<T> list, @Nonnull Object representative, @Nonnull Collector<T, ?, ?> finalCollector) {
            super(list, representative, finalCollector);
        }

        @Nonnull
        public List<T> getList() {
            return this.list;
        }

        @Nonnull
        public Grouper<?, List<T>> by(@Nonnull String fieldName) {
            return new Grouper(this.list, this.representative, Collections.singletonList(fieldName), Collectors.toList());
        }

        @Nonnull
        public <R> Counter<T, R> count() {
            return new Counter(this.getList(), this.representative, this.finalCollector);
        }

        @Nonnull
        public Grouper<?, List<T>> getAt(@Nonnull String fieldName) {
            return super.getAt(fieldName);
        }

        @Override
        public Object getProperty(String fieldName) {
            return super.getProperty(fieldName);
        }
    }
}

