/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.quality.gather;

import com.android.build.gradle.tasks.LintBaseTask;
import com.android.build.gradle.tasks.LintGlobalTask;
import com.android.build.gradle.tasks.LintPerVariantTask;
import java.io.File;
import java.util.List;
import kotlin.KotlinNothingValueException;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import net.twisterrob.gradle.common.Utils;
import net.twisterrob.gradle.quality.gather.LintReportGathererKt;
import net.twisterrob.gradle.quality.gather.TaskReportGatherer;
import org.gradle.api.Task;
import org.jetbrains.annotations.NotNull;
import se.bjurr.violations.lib.model.Violation;
import se.bjurr.violations.lib.reports.Parser;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00028\u00000\u0007\u00a2\u0006\u0002\u0010\bJ\u0016\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\f\u001a\u00020\rH\u0016J\u0015\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010J\u0015\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00028\u0000H\u0016\u00a2\u0006\u0002\u0010\u0010\u00a8\u0006\u0014"}, d2={"Lnet/twisterrob/gradle/quality/gather/LintReportGatherer;", "T", "Lcom/android/build/gradle/tasks/LintBaseTask;", "Lnet/twisterrob/gradle/quality/gather/TaskReportGatherer;", "displayName", "", "taskType", "Ljava/lang/Class;", "(Ljava/lang/String;Ljava/lang/Class;)V", "findViolations", "", "Lse/bjurr/violations/lib/model/Violation;", "report", "Ljava/io/File;", "getHumanReportLocation", "task", "(Lcom/android/build/gradle/tasks/LintBaseTask;)Ljava/io/File;", "getName", "(Lcom/android/build/gradle/tasks/LintBaseTask;)Ljava/lang/String;", "getParsableReportLocation", "twister-quality"})
public final class LintReportGatherer<T extends LintBaseTask>
extends TaskReportGatherer<T> {
    @Override
    @NotNull
    public File getParsableReportLocation(@NotNull T task) {
        File file;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        T t = task;
        if (t instanceof LintGlobalTask) {
            file = Utils.getXmlOutput(task);
        } else if (t instanceof LintPerVariantTask) {
            file = Utils.getXmlOutput(task);
        } else {
            Void void_ = LintReportGathererKt.access$unsupported((Task)task);
            throw new KotlinNothingValueException();
        }
        return file;
    }

    @Override
    @NotNull
    public File getHumanReportLocation(@NotNull T task) {
        File file;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        T t = task;
        if (t instanceof LintGlobalTask) {
            file = Utils.getHtmlOutput(task);
        } else if (t instanceof LintPerVariantTask) {
            file = Utils.getHtmlOutput(task);
        } else {
            Void void_ = LintReportGathererKt.access$unsupported((Task)task);
            throw new KotlinNothingValueException();
        }
        return file;
    }

    @Override
    @NotNull
    public String getName(@NotNull T task) {
        String string;
        Intrinsics.checkNotNullParameter(task, (String)"task");
        T t = task;
        if (t instanceof LintGlobalTask) {
            string = "*";
        } else if (t instanceof LintPerVariantTask) {
            String string2 = Utils.getAndroidVariantName(task);
            string = string2;
            Intrinsics.checkNotNull((Object)string2);
        } else {
            Void void_ = LintReportGathererKt.access$unsupported((Task)task);
            throw new KotlinNothingValueException();
        }
        return string;
    }

    @Override
    @NotNull
    public List<Violation> findViolations(@NotNull File report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        List list = Parser.ANDROIDLINT.findViolations(CollectionsKt.listOf((Object)report));
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"Parser.ANDROIDLINT.findViolations(listOf(report))");
        return list;
    }

    public LintReportGatherer(@NotNull String displayName, @NotNull Class<T> taskType) {
        Intrinsics.checkNotNullParameter((Object)displayName, (String)"displayName");
        Intrinsics.checkNotNullParameter(taskType, (String)"taskType");
        super(displayName, taskType);
    }
}

