/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.quality.report.html.model;

import java.io.File;
import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.twisterrob.gradle.quality.Violation;
import org.gradle.api.Project;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\bR\u0011\u0010\u000b\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u000eR\u0011\u0010\u0015\u001a\u00020\u00168F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0017R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001a\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u000eR\u0011\u0010\u001c\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u000eR\u000e\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010 \u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b!\u0010\u000eR\u0011\u0010\"\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b#\u0010\u000eR\u0011\u0010$\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b%\u0010\u000eR\u0011\u0010&\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b'\u0010\bR\u0011\u0010(\u001a\u00020\f8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u000e\u00a8\u0006*"}, d2={"Lnet/twisterrob/gradle/quality/report/html/model/LocationViewModel;", "", "violation", "Lnet/twisterrob/gradle/quality/Violation;", "(Lnet/twisterrob/gradle/quality/Violation;)V", "column", "", "getColumn", "()I", "endLine", "getEndLine", "file", "", "getFile", "()Ljava/lang/String;", "fileAbsoluteAsUrl", "Ljava/net/URI;", "getFileAbsoluteAsUrl", "()Ljava/net/URI;", "fileName", "getFileName", "isLocationExternal", "", "()Z", "loc", "Lnet/twisterrob/gradle/quality/Violation$Location;", "locationRelativeToModule", "getLocationRelativeToModule", "locationRelativeToProject", "getLocationRelativeToProject", "module", "Lorg/gradle/api/Project;", "moduleName", "getModuleName", "modulePath", "getModulePath", "modulePrefix", "getModulePrefix", "startLine", "getStartLine", "variant", "getVariant", "twister-quality"})
public final class LocationViewModel {
    private final Violation.Location loc;
    private final Project module;

    @NotNull
    public final String getModulePath() {
        String string = this.module.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"module.path");
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getModulePrefix() {
        String string = this.module.getPath();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 58: {
                    if (!string2.equals(":")) break;
                    return "";
                }
            }
        }
        String string3 = this.module.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"module.path");
        String string4 = string3;
        int n = 0;
        int n2 = this.module.getPath().length() - this.module.getName().length() - 1;
        boolean bl = false;
        String string5 = string4;
        if (string5 == null) {
            throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
        }
        String string6 = string5.substring(n, n2);
        String string7 = string6;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string7;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public final String getModuleName() {
        String string = this.module.getPath();
        if (string != null) {
            String string2 = string;
            switch (string2.hashCode()) {
                case 58: {
                    if (!string2.equals(":")) break;
                    return "";
                }
            }
        }
        String string3 = this.module.getName();
        String string4 = string3;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"module.name");
        return string4;
    }

    @NotNull
    public final String getVariant() {
        return this.loc.getVariant();
    }

    @NotNull
    public final String getFile() {
        String string = this.loc.getFile().getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loc.file.absolutePath");
        return string;
    }

    @NotNull
    public final String getFileName() {
        String string = this.loc.getFile().getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"loc.file.name");
        return string;
    }

    @NotNull
    public final URI getFileAbsoluteAsUrl() {
        URI uRI = this.loc.getFile().toURI();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"loc.file.toURI()");
        return uRI;
    }

    @NotNull
    public final String getLocationRelativeToProject() {
        return this.module.getRootProject().relativePath((Object)this.loc.getFile().getParentFile()) + File.separator;
    }

    @NotNull
    public final String getLocationRelativeToModule() {
        return this.module.relativePath((Object)this.loc.getFile().getParentFile()) + File.separator;
    }

    public final boolean isLocationExternal() {
        return StringsKt.startsWith$default((String)(this.module.getRootProject().relativePath((Object)this.loc.getFile().getParentFile()) + File.separator), (String)"", (boolean)false, (int)2, null);
    }

    public final int getStartLine() {
        return this.loc.getStartLine();
    }

    public final int getEndLine() {
        return this.loc.getEndLine();
    }

    public final int getColumn() {
        return this.loc.getColumn();
    }

    public LocationViewModel(@NotNull Violation violation) {
        Intrinsics.checkNotNullParameter((Object)violation, (String)"violation");
        this.loc = violation.getLocation();
        this.module = this.loc.getModule();
    }
}

