/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.quality.report.html.model;

import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import net.twisterrob.gradle.quality.Violation;
import net.twisterrob.gradle.quality.report.html.model.SuppressionGeneratorKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lnet/twisterrob/gradle/quality/report/html/model/SuppressionGenerator;", "", "()V", "getSuppression", "", "v", "Lnet/twisterrob/gradle/quality/Violation;", "twister-quality"})
public final class SuppressionGenerator {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    public final String getSuppression(@NotNull Violation v) {
        String string;
        block33: {
            Intrinsics.checkNotNullParameter((Object)v, (String)"v");
            String string2 = v.getSource().getReporter();
            switch (string2.hashCode()) {
                case -14743127: {
                    if (!string2.equals("CHECKSTYLE")) return null;
                    break;
                }
                case 79335: {
                    if (!string2.equals("PMD")) return null;
                    break block33;
                }
                case -1203787054: {
                    if (!string2.equals("ANDROIDLINT")) return null;
                    switch (FilesKt.getExtension((File)v.getLocation().getFile())) {
                        case "java": {
                            string = "@SuppressLint(\"" + v.getRule() + "\") // TODO explanation";
                            return string;
                        }
                        case "kt": {
                            string = "@SuppressLint(\"" + v.getRule() + "\") // TODO explanation";
                            return string;
                        }
                        case "xml": {
                            string = "tools:ignore=\"" + v.getRule() + '\"';
                            return string;
                        }
                        case "gradle": {
                            string = "//noinspection " + v.getRule() + " TODO explanation";
                            return string;
                        }
                        default: {
                            string = StringsKt.trimIndent((String)("\n\t\t\t\t\t\t<issue id=\"" + v.getRule() + "\" severity=\"ignore\">\n\t\t\t\t\t\t    <!-- TODO explanation -->\n\t\t\t\t\t\t    <ignore path=\"" + (SuppressionGeneratorKt.access$isLocationExternal$p(v) ? v.getLocation().getFile().getName() : SuppressionGeneratorKt.access$getLocationRelativeToModule$p(v)) + "\" />\n\t\t\t\t\t\t</issue>\n\t\t\t\t\t"));
                            return string;
                        }
                    }
                }
            }
            switch (FilesKt.getExtension((File)v.getLocation().getFile())) {
                case "java": {
                    string = "@SuppressWarnings(\"checkstyle:" + v.getRule() + "\") // TODO explanation";
                    return string;
                }
                case "kt": {
                    string = "@Suppress(\"checkstyle:" + v.getRule() + "\") // TODO explanation";
                    return string;
                }
                default: {
                    return null;
                }
            }
        }
        switch (FilesKt.getExtension((File)v.getLocation().getFile())) {
            case "java": {
                string = "@SuppressWarnings(\"PMD." + v.getRule() + "\") // TODO explanation";
                return string;
            }
            case "kt": {
                string = "@Suppress(\"PMD." + v.getRule() + "\") // TODO explanation";
                return string;
            }
            default: {
                return null;
            }
        }
        return null;
    }
}

