/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.quality.tasks;

import com.android.utils.SdkUtils;
import com.google.common.annotations.VisibleForTesting;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import net.twisterrob.gradle.common.grouper.Grouper;
import net.twisterrob.gradle.compat.GradleCompatKt;
import net.twisterrob.gradle.dsl.ProjectExtensionsKt;
import net.twisterrob.gradle.quality.Violations;
import net.twisterrob.gradle.quality.report.html.XmlProducerKt;
import net.twisterrob.gradle.quality.tasks.ValidateViolationsTask;
import org.gradle.api.Action;
import org.gradle.api.DefaultTask;
import org.gradle.api.GradleException;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.file.RegularFile;
import org.gradle.api.file.RegularFileProperty;
import org.gradle.api.provider.Provider;
import org.gradle.api.tasks.InputFile;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputFile;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aH\u0014J\r\u0010\u001c\u001a\u00020\u0018H\u0001\u00a2\u0006\u0002\b\u001dR\u0013\u0010\u0003\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0013\u0010\u000b\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u0006R\u0014\u0010\r\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0013\u0010\u000f\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0014\u0010\u0011\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0013\u0010\u0013\u001a\u00020\u00048G\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0016\u0010\u0015\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\n\u00a8\u0006\u001e"}, d2={"Lnet/twisterrob/gradle/quality/tasks/HtmlReportTask;", "Lnet/twisterrob/gradle/quality/tasks/ValidateViolationsTask;", "()V", "html", "Lorg/gradle/api/file/RegularFileProperty;", "getHtml", "()Lorg/gradle/api/file/RegularFileProperty;", "htmlFile", "Ljava/io/File;", "getHtmlFile", "()Ljava/io/File;", "xml", "getXml", "xmlFile", "getXmlFile", "xsl", "getXsl", "xslOutputFile", "getXslOutputFile", "xslTemplate", "getXslTemplate", "xslTemplateFile", "getXslTemplateFile", "processViolations", "", "violations", "Lnet/twisterrob/gradle/common/grouper/Grouper$Start;", "Lnet/twisterrob/gradle/quality/Violations;", "transform", "transform$twister_quality", "twister-quality"})
public class HtmlReportTask
extends ValidateViolationsTask {
    @NotNull
    private final RegularFileProperty xml = GradleCompatKt.newOutputFileCompat((DefaultTask)this);
    @NotNull
    private final RegularFileProperty html = GradleCompatKt.newOutputFileCompat((DefaultTask)this);
    @NotNull
    private final RegularFileProperty xslTemplate = GradleCompatKt.newInputFileCompat((DefaultTask)this);
    @NotNull
    private final RegularFileProperty xsl = GradleCompatKt.newOutputFileCompat((DefaultTask)this);

    private final File getXmlFile() {
        Object object = this.xml.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xml.asFile.get()");
        return (File)object;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getXml() {
        return this.xml;
    }

    private final File getHtmlFile() {
        Object object = this.html.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"html.asFile.get()");
        return (File)object;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getHtml() {
        return this.html;
    }

    private final File getXslTemplateFile() {
        Provider provider = this.xslTemplate.getAsFile();
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"xslTemplate.asFile");
        return (File)provider.getOrNull();
    }

    @InputFile
    @Optional
    @NotNull
    public final RegularFileProperty getXslTemplate() {
        return this.xslTemplate;
    }

    private final File getXslOutputFile() {
        Object object = this.xsl.getAsFile().get();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"xsl.asFile.get()");
        return (File)object;
    }

    @OutputFile
    @NotNull
    public final RegularFileProperty getXsl() {
        return this.xsl;
    }

    @Override
    protected void processViolations(@NotNull Grouper.Start<Violations> violations) {
        Intrinsics.checkNotNullParameter(violations, (String)"violations");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        XmlProducerKt.produceXml(project, violations, this.getXmlFile(), this.getXslOutputFile());
        String string = "Wrote XML report to " + SdkUtils.fileToUrlString((File)this.getXmlFile().getAbsoluteFile());
        boolean bl = false;
        System.out.println((Object)string);
    }

    @VisibleForTesting
    public final void transform$twister_quality() {
        try {
            Object object = this.getXslOutputFile();
            Charset charset = Charsets.UTF_8;
            boolean bl = false;
            Object object2 = object;
            boolean bl2 = false;
            object2 = new FileInputStream((File)object2);
            bl2 = false;
            StreamSource streamSource = new StreamSource(new InputStreamReader((InputStream)object2, charset));
            object = this.getXmlFile();
            charset = Charsets.UTF_8;
            bl = false;
            object2 = object;
            bl2 = false;
            object2 = new FileInputStream((File)object2);
            bl2 = false;
            TransformerFactory.newInstance().newTransformer(streamSource).transform(new StreamSource(new InputStreamReader((InputStream)object2, charset)), new StreamResult(this.getHtmlFile()));
            object = "Wrote HTML report to " + SdkUtils.fileToUrlString((File)this.getHtmlFile().getAbsoluteFile());
            boolean bl3 = false;
            System.out.println(object);
        }
        catch (Throwable ex) {
            throw (Throwable)new GradleException("Cannot transform " + this.getXmlFile() + "\nto " + this.getHtmlFile() + "\nusing " + this.getXslOutputFile(), ex);
        }
    }

    public HtmlReportTask() {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Provider provider = ProjectExtensionsKt.getReporting((Project)project).getBaseDirectory().file("violations.xml");
        Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.reporting.baseDi\u2026ry.file(\"violations.xml\")");
        GradleCompatKt.conventionCompat((RegularFileProperty)this.xml, (Provider)provider);
        Project project2 = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project2, (String)"project");
        Provider provider2 = ProjectExtensionsKt.getReporting((Project)project2).getBaseDirectory().file("violations.html");
        Intrinsics.checkNotNullExpressionValue((Object)provider2, (String)"project.reporting.baseDi\u2026y.file(\"violations.html\")");
        GradleCompatKt.conventionCompat((RegularFileProperty)this.html, (Provider)provider2);
        GradleCompatKt.conventionCompat((RegularFileProperty)this.xsl, (Provider)GradleCompatKt.flatMapCompat((Provider)((Provider)this.xml), (Function1)((Function1)new Function1<RegularFile, Provider<RegularFile>>(){

            @NotNull
            public final Provider<RegularFile> invoke(final RegularFile regular) {
                Project project = this.getProject();
                Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                Provider provider = project.getLayout().file(this.getProject().provider((Callable)new Callable<File>(){

                    @Override
                    public final File call() {
                        RegularFile regularFile = regular;
                        Intrinsics.checkNotNullExpressionValue((Object)regularFile, (String)"regular");
                        File file = regularFile.getAsFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"regular.asFile");
                        File file2 = file.getParentFile();
                        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"regular.asFile.parentFile");
                        Object object = this.getXslTemplateFile();
                        if (object == null || (object = ((File)object).getName()) == null) {
                            object = "violations.xsl";
                        }
                        return FilesKt.resolve((File)file2, (String)object);
                    }
                }));
                Intrinsics.checkNotNullExpressionValue((Object)provider, (String)"project.layout.file(proj\u2026 \"violations.xsl\")\n\t\t\t\t})");
                return provider;
            }
        })));
        this.doFirst((Action)new Action<Task>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final void execute(Task it) {
                File file = this.getXslTemplateFile();
                if (file != null) {
                    if (file.exists()) {
                        File file2 = this.getXslTemplateFile();
                        Intrinsics.checkNotNull((Object)file2);
                        FilesKt.copyTo$default((File)file2, (File)this.getXslOutputFile(), (boolean)true, (int)0, (int)4, null);
                        return;
                    }
                }
                InputStream inputStream = ((Object)((Object)this)).getClass().getResourceAsStream("/violations.xsl");
                Intrinsics.checkNotNull((Object)inputStream);
                InputStream builtIn = inputStream;
                Closeable closeable = builtIn;
                boolean bl = false;
                boolean bl2 = false;
                Throwable throwable = null;
                try {
                    long l;
                    InputStream input = (InputStream)closeable;
                    boolean bl3 = false;
                    Object object = this.getXslOutputFile();
                    boolean bl4 = false;
                    object = new FileOutputStream((File)object);
                    bl4 = false;
                    boolean bl5 = false;
                    Throwable throwable2 = null;
                    try {
                        FileOutputStream output = (FileOutputStream)object;
                        boolean bl6 = false;
                        l = ByteStreamsKt.copyTo$default((InputStream)input, (OutputStream)output, (int)0, (int)2, null);
                    }
                    catch (Throwable throwable3) {
                        throwable2 = throwable3;
                        throw throwable3;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object, (Throwable)throwable2);
                    }
                    long l2 = l;
                    return;
                }
                catch (Throwable throwable4) {
                    throwable = throwable4;
                    throw throwable4;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        });
        this.doLast((Action)new Action<Task>(){

            public final void execute(Task it) {
                this.transform$twister_quality();
            }
        });
    }
}

