/*
 * Decompiled with CFR 0.152.
 */
package net.twisterrob.gradle.quality.tasks;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.gradle.api.DefaultTask;
import org.gradle.api.Project;
import org.gradle.api.invocation.Gradle;
import org.gradle.api.plugins.quality.CheckstyleExtension;
import org.gradle.api.plugins.quality.CodeQualityExtension;
import org.gradle.api.plugins.quality.PmdExtension;
import org.gradle.api.specs.Spec;
import org.gradle.api.tasks.TaskAction;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00042\u000e\u0010\u0006\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0\u0007H\u0002J\b\u0010\t\u001a\u00020\nH\u0007\u00a8\u0006\u000b"}, d2={"Lnet/twisterrob/gradle/quality/tasks/VersionsTask;", "Lorg/gradle/api/DefaultTask;", "()V", "getVersion", "", "pluginName", "type", "Ljava/lang/Class;", "Lorg/gradle/api/plugins/quality/CodeQualityExtension;", "printVersions", "", "twister-quality"})
public class VersionsTask
extends DefaultTask {
    @TaskAction
    public final void printVersions() {
        StringBuilder stringBuilder = new StringBuilder().append("\n\t\t\tGradle version: ");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Gradle gradle = project.getGradle();
        Intrinsics.checkNotNullExpressionValue((Object)gradle, (String)"project.gradle");
        String string = StringsKt.trimIndent((String)stringBuilder.append(gradle.getGradleVersion()).append("\n\t\t\tCheckstyle version: ").append(this.getVersion("checkstyle", CheckstyleExtension.class)).append("\n\t\t\tPMD version: ").append(this.getVersion("pmd", PmdExtension.class)).append("\n\t\t\t").toString());
        boolean bl = false;
        System.out.println((Object)string);
    }

    private final String getVersion(String pluginName, Class<? extends CodeQualityExtension> type) {
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        Object object = (CodeQualityExtension)project.getExtensions().findByType(type);
        if (object == null || (object = object.getToolVersion()) == null) {
            object = '\'' + pluginName + "' plugin not applied";
        }
        return object;
    }

    public VersionsTask() {
        this.getOutputs().upToDateWhen((Spec)1.INSTANCE);
    }
}

