/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.concurrent.atomic.AtomicBoolean;
import net.uncontended.precipice.RejectedActionException;
import net.uncontended.precipice.RejectionReason;
import net.uncontended.precipice.Service;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.Metric;

public abstract class AbstractService
implements Service {
    protected final PrecipiceSemaphore semaphore;
    protected final AtomicBoolean isShutdown;
    protected final ActionMetrics actionMetrics;
    protected final CircuitBreaker circuitBreaker;

    public AbstractService(CircuitBreaker circuitBreaker, ActionMetrics actionMetrics, PrecipiceSemaphore semaphore) {
        this(circuitBreaker, actionMetrics, semaphore, new AtomicBoolean(false));
    }

    public AbstractService(CircuitBreaker circuitBreaker, ActionMetrics actionMetrics, PrecipiceSemaphore semaphore, AtomicBoolean isShutdown) {
        this.circuitBreaker = circuitBreaker;
        this.actionMetrics = actionMetrics;
        this.semaphore = semaphore;
        this.isShutdown = isShutdown;
    }

    @Override
    public ActionMetrics getActionMetrics() {
        return this.actionMetrics;
    }

    @Override
    public CircuitBreaker getCircuitBreaker() {
        return this.circuitBreaker;
    }

    protected void acquirePermitOrRejectIfActionNotAllowed() {
        if (this.isShutdown.get()) {
            throw new RejectedActionException(RejectionReason.SERVICE_SHUTDOWN);
        }
        boolean isPermitAcquired = this.semaphore.acquirePermit();
        if (!isPermitAcquired) {
            this.actionMetrics.incrementMetricCount(Metric.MAX_CONCURRENCY_LEVEL_EXCEEDED);
            throw new RejectedActionException(RejectionReason.MAX_CONCURRENCY_LEVEL_EXCEEDED);
        }
        if (!this.circuitBreaker.allowAction()) {
            this.actionMetrics.incrementMetricCount(Metric.CIRCUIT_OPEN);
            this.semaphore.releasePermit();
            throw new RejectedActionException(RejectionReason.CIRCUIT_OPEN);
        }
    }
}

