/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.concurrent.atomic.AtomicBoolean;
import net.uncontended.precipice.AbstractService;
import net.uncontended.precipice.ResilientAction;
import net.uncontended.precipice.RunService;
import net.uncontended.precipice.Status;
import net.uncontended.precipice.circuit.BreakerConfigBuilder;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.circuit.DefaultCircuitBreaker;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.DefaultActionMetrics;
import net.uncontended.precipice.metrics.Metric;
import net.uncontended.precipice.timeout.ActionTimeoutException;

public class DefaultRunService
extends AbstractService
implements RunService {
    public DefaultRunService(PrecipiceSemaphore semaphore) {
        this(semaphore, new DefaultActionMetrics());
    }

    public DefaultRunService(PrecipiceSemaphore semaphore, ActionMetrics actionMetrics) {
        this(semaphore, actionMetrics, new DefaultCircuitBreaker(actionMetrics, new BreakerConfigBuilder().build()));
    }

    public DefaultRunService(PrecipiceSemaphore semaphore, CircuitBreaker breaker) {
        this(semaphore, (ActionMetrics)new DefaultActionMetrics(), breaker);
    }

    public DefaultRunService(PrecipiceSemaphore semaphore, ActionMetrics actionMetrics, CircuitBreaker circuitBreaker) {
        super(circuitBreaker, actionMetrics, semaphore);
    }

    public DefaultRunService(PrecipiceSemaphore semaphore, ActionMetrics actionMetrics, CircuitBreaker circuitBreaker, AtomicBoolean isShutdown) {
        super(circuitBreaker, actionMetrics, semaphore, isShutdown);
    }

    @Override
    public <T> T run(ResilientAction<T> action) throws Exception {
        this.acquirePermitOrRejectIfActionNotAllowed();
        try {
            T result = action.run();
            this.actionMetrics.incrementMetricCount(Metric.statusToMetric(Status.SUCCESS));
            T t = result;
            return t;
        }
        catch (ActionTimeoutException e) {
            this.actionMetrics.incrementMetricCount(Metric.statusToMetric(Status.TIMEOUT));
            throw e;
        }
        catch (Exception e) {
            this.actionMetrics.incrementMetricCount(Metric.statusToMetric(Status.ERROR));
            throw e;
        }
        finally {
            this.semaphore.releasePermit();
        }
    }

    @Override
    public void shutdown() {
        this.isShutdown.compareAndSet(false, true);
    }
}

