/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import net.uncontended.precipice.AbstractService;
import net.uncontended.precipice.DefaultCompletionService;
import net.uncontended.precipice.DefaultRunService;
import net.uncontended.precipice.DefaultSubmissionService;
import net.uncontended.precipice.MultiService;
import net.uncontended.precipice.ResilientAction;
import net.uncontended.precipice.ResilientCallback;
import net.uncontended.precipice.RunService;
import net.uncontended.precipice.circuit.BreakerConfigBuilder;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.circuit.DefaultCircuitBreaker;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;
import net.uncontended.precipice.concurrent.ResilientFuture;
import net.uncontended.precipice.concurrent.ResilientPromise;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.DefaultActionMetrics;

public class DefaultService
extends AbstractService
implements MultiService {
    private final ExecutorService service;
    private final RunService runService;
    private final DefaultSubmissionService submissionService;
    private final DefaultCompletionService completionService;

    public DefaultService(ExecutorService service, PrecipiceSemaphore semaphore) {
        this(service, semaphore, new DefaultActionMetrics());
    }

    public DefaultService(ExecutorService service, PrecipiceSemaphore semaphore, ActionMetrics actionMetrics) {
        this(service, semaphore, actionMetrics, new DefaultCircuitBreaker(actionMetrics, new BreakerConfigBuilder().build()));
    }

    public DefaultService(ExecutorService service, PrecipiceSemaphore semaphore, CircuitBreaker breaker) {
        this(service, semaphore, new DefaultActionMetrics(), breaker);
    }

    public DefaultService(ExecutorService service, PrecipiceSemaphore semaphore, ActionMetrics actionMetrics, CircuitBreaker circuitBreaker) {
        this(service, semaphore, actionMetrics, circuitBreaker, new AtomicBoolean(false));
    }

    private DefaultService(ExecutorService service, PrecipiceSemaphore semaphore, ActionMetrics actionMetrics, CircuitBreaker circuitBreaker, AtomicBoolean isShutdown) {
        super(circuitBreaker, actionMetrics, semaphore, isShutdown);
        this.service = service;
        this.runService = new DefaultRunService(semaphore, actionMetrics, circuitBreaker, isShutdown);
        this.submissionService = new DefaultSubmissionService(service, semaphore, actionMetrics, circuitBreaker, isShutdown);
        this.completionService = new DefaultCompletionService(service, semaphore, actionMetrics, circuitBreaker, isShutdown);
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientAction<T> action, long millisTimeout) {
        return this.submissionService.submit(action, millisTimeout);
    }

    @Override
    public <T> void submitAndComplete(ResilientAction<T> action, ResilientPromise<T> promise, long millisTimeout) {
        this.completionService.submitAndComplete(action, promise, null, millisTimeout);
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientAction<T> action, ResilientCallback<T> callback, long millisTimeout) {
        return this.submissionService.submit(action, callback, millisTimeout);
    }

    @Override
    public <T> void submitAndComplete(ResilientAction<T> action, ResilientPromise<T> promise, ResilientCallback<T> callback, long millisTimeout) {
        this.completionService.submitAndComplete(action, promise, callback, millisTimeout);
    }

    @Override
    public <T> T run(ResilientAction<T> action) throws Exception {
        try {
            T t = this.runService.run(action);
            return t;
        }
        finally {
            this.semaphore.releasePermit();
        }
    }

    @Override
    public void shutdown() {
        this.isShutdown.compareAndSet(false, true);
        this.service.shutdown();
    }
}

