/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice;

import java.util.concurrent.ExecutorService;
import net.uncontended.precipice.CompletionService;
import net.uncontended.precipice.DefaultCompletionService;
import net.uncontended.precipice.DefaultRunService;
import net.uncontended.precipice.DefaultService;
import net.uncontended.precipice.DefaultSubmissionService;
import net.uncontended.precipice.MultiService;
import net.uncontended.precipice.RunService;
import net.uncontended.precipice.SubmissionService;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.circuit.NoOpCircuitBreaker;
import net.uncontended.precipice.concurrent.IntegerSemaphore;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.utils.PrecipiceExecutors;

public class Services {
    public static SubmissionService submissionService(String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultSubmissionService(executor, new IntegerSemaphore(concurrencyLevel));
    }

    public static SubmissionService submissionService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultSubmissionService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), metrics);
    }

    public static SubmissionService submissionService(String name, int poolSize, int concurrencyLevel, CircuitBreaker breaker) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultSubmissionService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), breaker);
    }

    public static SubmissionService submissionService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultSubmissionService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static SubmissionService submissionService(ExecutorService executor, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        return new DefaultSubmissionService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static RunService runService(String name, int concurrencyLevel) {
        return new DefaultRunService(new IntegerSemaphore(concurrencyLevel));
    }

    public static RunService runService(String name, int concurrencyLevel, ActionMetrics metrics) {
        return new DefaultRunService((PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), metrics);
    }

    public static RunService runService(String name, int concurrencyLevel, CircuitBreaker breaker) {
        return new DefaultRunService((PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), breaker);
    }

    public static RunService runService(String name, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        return new DefaultRunService(new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static RunService completionServiceWithNoOpBreaker(String name, int concurrencyLevel) {
        return new DefaultRunService((PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), new NoOpCircuitBreaker());
    }

    public static CompletionService completionService(String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultCompletionService(executor, new IntegerSemaphore(concurrencyLevel));
    }

    public static CompletionService completionService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultCompletionService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), metrics);
    }

    public static CompletionService completionService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultCompletionService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static CompletionService completionService(ExecutorService executor, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        return new DefaultCompletionService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static CompletionService completionServiceWithNoOpBreaker(String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultCompletionService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), new NoOpCircuitBreaker());
    }

    public static MultiService defaultService(String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultService(executor, new IntegerSemaphore(concurrencyLevel));
    }

    public static MultiService defaultServiceWithNoOpBreaker(String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), new NoOpCircuitBreaker());
    }

    public static MultiService defaultService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultService(executor, (PrecipiceSemaphore)new IntegerSemaphore(concurrencyLevel), metrics);
    }

    public static MultiService defaultService(String name, int poolSize, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        return new DefaultService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }

    public static MultiService defaultService(ExecutorService executor, int concurrencyLevel, ActionMetrics metrics, CircuitBreaker breaker) {
        return new DefaultService(executor, new IntegerSemaphore(concurrencyLevel), metrics, breaker);
    }
}

