/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.circuit;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import net.uncontended.precipice.circuit.BreakerConfig;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.HealthSnapshot;
import net.uncontended.precipice.utils.SystemTime;

public class DefaultCircuitBreaker
implements CircuitBreaker {
    private static final int CLOSED = 0;
    private static final int OPEN = 1;
    private static final int FORCED_OPEN = 2;
    private final SystemTime systemTime;
    private final ActionMetrics actionMetrics;
    private final AtomicInteger state = new AtomicInteger(0);
    private final AtomicLong lastTestedTime = new AtomicLong(0L);
    private final AtomicLong lastHealthTime = new AtomicLong(0L);
    private final AtomicReference<HealthSnapshot> health = new AtomicReference();
    private final AtomicReference<BreakerConfig> breakerConfig;

    public DefaultCircuitBreaker(ActionMetrics actionMetrics, BreakerConfig breakerConfig) {
        this(actionMetrics, breakerConfig, new SystemTime());
    }

    public DefaultCircuitBreaker(ActionMetrics actionMetrics, BreakerConfig breakerConfig, SystemTime systemTime) {
        this.systemTime = systemTime;
        this.actionMetrics = actionMetrics;
        this.breakerConfig = new AtomicReference<BreakerConfig>(breakerConfig);
    }

    @Override
    public boolean isOpen() {
        return this.state.get() != 0;
    }

    @Override
    public boolean allowAction() {
        int state = this.state.get();
        if (state == 1) {
            long backOffTimeMillis = this.breakerConfig.get().backOffTimeMillis;
            long currentTime = this.systemTime.currentTimeMillis();
            if (currentTime < backOffTimeMillis + this.lastTestedTime.get()) {
                return false;
            }
            this.lastTestedTime.set(currentTime);
        }
        return state != 2;
    }

    @Override
    public void informBreakerOfResult(boolean successful) {
        if (successful) {
            if (this.state.get() == 1) {
                this.state.compareAndSet(1, 0);
            }
        } else if (this.state.get() == 0) {
            long currentTime = this.systemTime.currentTimeMillis();
            BreakerConfig config = this.breakerConfig.get();
            HealthSnapshot health = this.getHealthSnapshot(config, currentTime);
            long failures = health.failures;
            double failurePercentage = health.failurePercentage();
            if (config.failureThreshold < failures || (double)config.failurePercentageThreshold < failurePercentage) {
                this.lastTestedTime.set(currentTime);
                this.state.compareAndSet(0, 1);
            }
        }
    }

    private HealthSnapshot getHealthSnapshot(BreakerConfig config, long currentTime) {
        long lastHealthTime = this.lastHealthTime.get();
        if (lastHealthTime + config.healthRefreshMillis < currentTime && this.lastHealthTime.compareAndSet(lastHealthTime, currentTime)) {
            HealthSnapshot newHealth = this.actionMetrics.healthSnapshot(config.trailingPeriodMillis, TimeUnit.MILLISECONDS);
            this.health.set(newHealth);
            return newHealth;
        }
        return this.health.get();
    }

    @Override
    public BreakerConfig getBreakerConfig() {
        return this.breakerConfig.get();
    }

    @Override
    public void setBreakerConfig(BreakerConfig breakerConfig) {
        this.breakerConfig.set(breakerConfig);
    }

    @Override
    public void forceOpen() {
        this.state.set(2);
    }

    @Override
    public void forceClosed() {
        this.state.set(0);
    }
}

