/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.uncontended.precipice.Status;
import net.uncontended.precipice.concurrent.ResilientPromise;

public abstract class AbstractResilientPromise<T>
implements ResilientPromise<T> {
    protected volatile T result;
    volatile Exception error;
    final AtomicReference<Status> status = new AtomicReference<Status>(Status.PENDING);
    final CountDownLatch latch = new CountDownLatch(1);
    ResilientPromise<T> wrappedPromise;

    @Override
    public void await() throws InterruptedException {
        this.latch.await();
    }

    @Override
    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.latch.await(timeout, unit);
    }

    @Override
    public T awaitResult() throws InterruptedException {
        this.latch.await();
        return this.result;
    }

    @Override
    public T getResult() {
        return this.result;
    }

    @Override
    public Exception getError() {
        return this.error;
    }

    @Override
    public Status getStatus() {
        return this.status.get();
    }

    @Override
    public boolean isSuccessful() {
        return this.status.get() == Status.SUCCESS;
    }

    @Override
    public boolean isDone() {
        return this.status.get() != Status.PENDING;
    }

    @Override
    public boolean isError() {
        return this.status.get() == Status.ERROR;
    }

    @Override
    public boolean isTimedOut() {
        return this.status.get() == Status.TIMEOUT;
    }

    public void wrapPromise(ResilientPromise<T> promise) {
        this.wrappedPromise = promise;
    }
}

