/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.Comparator;
import java.util.NavigableSet;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.locks.LockSupport;
import net.uncontended.precipice.concurrent.ExchangingQueue;

public class ActionThreadPool
implements Executor {
    private final NavigableSet<ThreadManager> pool;
    private final ThreadLocalRandom random = ThreadLocalRandom.current();

    public ActionThreadPool(String actionName, int threadCount) {
        if (threadCount < 1) {
            throw new IllegalArgumentException("Cannot have fewer than 1 thread");
        }
        this.pool = new TreeSet<ThreadManager>(new Comparator<ThreadManager>(){

            @Override
            public int compare(ThreadManager o1, ThreadManager o2) {
                int scheduledCount2;
                int scheduledCount1 = o1.getScheduledCount();
                if (scheduledCount1 > (scheduledCount2 = o2.getScheduledCount())) {
                    return 1;
                }
                if (scheduledCount2 > scheduledCount1) {
                    return -1;
                }
                if (ActionThreadPool.this.random.nextBoolean()) {
                    return 1;
                }
                return -1;
            }
        });
        for (int i = 0; i < threadCount; ++i) {
            this.pool.add(new ThreadManager(actionName + "-" + i));
        }
    }

    @Override
    public void execute(Runnable action) {
        ThreadManager nextThread = this.pool.pollFirst();
        boolean submitted = nextThread.submit(action);
        this.pool.add(nextThread);
        if (!submitted) {
            throw new RejectedExecutionException();
        }
    }

    public void signalTaskComplete(ThreadManager threadManager) {
        threadManager.decrementScheduledCount();
        this.pool.remove(threadManager);
        this.pool.add(threadManager);
    }

    public void shutdown() {
        for (ThreadManager manager : this.pool) {
            manager.shutdown();
        }
    }

    private class ThreadManager {
        private final ExchangingQueue<Runnable> queue = new ExchangingQueue(10);
        private final Thread thread;
        private int scheduledCount = 0;

        public ThreadManager(String threadName) {
            this.thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    do {
                        Runnable runnable;
                        try {
                            runnable = (Runnable)ThreadManager.this.queue.blockingPoll();
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                        runnable.run();
                    } while (!ThreadManager.this.thread.isInterrupted());
                }
            }, threadName);
            this.thread.start();
        }

        private boolean submit(Runnable task) {
            boolean offered = this.queue.offer(task);
            if (offered) {
                ++this.scheduledCount;
            }
            return offered;
        }

        private void decrementScheduledCount() {
            --this.scheduledCount;
        }

        private int getScheduledCount() {
            return this.scheduledCount;
        }

        private void shutdown() {
            this.thread.interrupt();
            LockSupport.unpark(this.thread);
        }
    }
}

