/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import net.uncontended.precipice.Status;
import net.uncontended.precipice.concurrent.AbstractResilientPromise;

public class DefaultResilientPromise<T>
extends AbstractResilientPromise<T> {
    @Override
    public boolean deliverResult(T result) {
        if (this.status.get() == Status.PENDING && this.status.compareAndSet(Status.PENDING, Status.SUCCESS)) {
            this.result = result;
            if (this.wrappedPromise != null) {
                this.wrappedPromise.deliverResult(result);
            }
            this.latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean deliverError(Exception error) {
        if (this.status.get() == Status.PENDING && this.status.compareAndSet(Status.PENDING, Status.ERROR)) {
            this.error = error;
            if (this.wrappedPromise != null) {
                this.wrappedPromise.deliverError(error);
            }
            this.latch.countDown();
            return true;
        }
        return false;
    }

    @Override
    public boolean setTimedOut() {
        if (this.status.get() == Status.PENDING && this.status.compareAndSet(Status.PENDING, Status.TIMEOUT)) {
            if (this.wrappedPromise != null) {
                this.wrappedPromise.setTimedOut();
            }
            this.latch.countDown();
            return true;
        }
        return false;
    }
}

