/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.LockSupport;

public class ExchangingQueue<T> {
    private final T[] queue;
    private final int capacity;
    private final int mask;
    private final AtomicInteger head = new AtomicInteger(0);
    private final AtomicInteger tail = new AtomicInteger(0);
    private volatile Thread waiter = null;

    public ExchangingQueue(int capacity) {
        this.capacity = 1 << 32 - Integer.numberOfLeadingZeros(capacity - 1);
        this.mask = this.capacity - 1;
        this.queue = new Object[this.capacity];
    }

    public boolean offer(T element) {
        if (null == element) {
            throw new NullPointerException("Cannot put null in the queue");
        }
        int currentTail = this.tail.get();
        int wrapPoint = currentTail - this.capacity;
        if (this.head.get() <= wrapPoint) {
            return false;
        }
        this.queue[currentTail & this.mask] = element;
        this.tail.lazySet(currentTail + 1);
        if (this.waiter != null) {
            LockSupport.unpark(this.waiter);
        }
        return true;
    }

    public T poll() {
        int currentHead = this.head.get();
        if (currentHead >= this.tail.get()) {
            return null;
        }
        int index = currentHead & this.mask;
        T element = this.queue[index];
        this.queue[index] = null;
        this.head.lazySet(currentHead + 1);
        return element;
    }

    public T blockingPoll() throws InterruptedException {
        do {
            T element;
            if ((element = this.poll()) != null) {
                return element;
            }
            this.waiter = Thread.currentThread();
            LockSupport.park();
            this.waiter = null;
        } while (!Thread.currentThread().isInterrupted());
        throw new InterruptedException();
    }
}

