/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.atomic.AtomicInteger;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;

public class IntegerSemaphore
implements PrecipiceSemaphore {
    private final AtomicInteger permitsRemaining;

    public IntegerSemaphore(int concurrencyLevel) {
        this.permitsRemaining = new AtomicInteger(concurrencyLevel);
    }

    @Override
    public boolean acquirePermit() {
        int permitsRemaining;
        while ((permitsRemaining = this.permitsRemaining.get()) > 0) {
            if (!this.permitsRemaining.compareAndSet(permitsRemaining, permitsRemaining - 1)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void releasePermit() {
        this.permitsRemaining.getAndIncrement();
    }
}

