/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.uncontended.precipice.Status;
import net.uncontended.precipice.concurrent.ResilientPromise;

public class ResilientFuture<T>
implements Future {
    public final ResilientPromise<T> promise;

    public ResilientFuture(ResilientPromise<T> promise) {
        this.promise = promise;
    }

    public T get() throws InterruptedException, ExecutionException {
        this.promise.await();
        if (this.promise.isError()) {
            throw new ExecutionException(this.promise.getError());
        }
        return this.promise.getResult();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        boolean await = this.promise.await(timeout, unit);
        if (!await) {
            throw new TimeoutException();
        }
        if (this.promise.isError()) {
            throw new ExecutionException(this.promise.getError());
        }
        return this.promise.getResult();
    }

    @Override
    public boolean isDone() {
        return this.promise.isDone();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        throw new UnsupportedOperationException("Cancellation is not supported.");
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    public Status getStatus() {
        return this.promise.getStatus();
    }
}

