/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.concurrent;

import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import net.uncontended.precipice.ResilientAction;
import net.uncontended.precipice.ResilientCallback;
import net.uncontended.precipice.Status;
import net.uncontended.precipice.circuit.CircuitBreaker;
import net.uncontended.precipice.concurrent.PrecipiceSemaphore;
import net.uncontended.precipice.concurrent.ResilientPromise;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.Metric;

public class ResilientTask<T>
implements Runnable,
Delayed {
    public final AtomicReference<Status> status = new AtomicReference<Status>(Status.PENDING);
    public final long millisAbsoluteTimeout;
    private final ResilientPromise<T> promise;
    private final ActionMetrics metrics;
    private final PrecipiceSemaphore semaphore;
    private final CircuitBreaker breaker;
    private final ResilientAction<T> action;
    private final ResilientCallback<T> callback;
    private volatile Thread runner;

    public ResilientTask(ActionMetrics metrics, PrecipiceSemaphore semaphore, CircuitBreaker breaker, ResilientAction<T> action, ResilientCallback<T> callback, ResilientPromise<T> promise, long millisRelativeTimeout) {
        this.metrics = metrics;
        this.semaphore = semaphore;
        this.breaker = breaker;
        this.action = action;
        this.callback = callback;
        this.promise = promise;
        this.millisAbsoluteTimeout = millisRelativeTimeout + System.currentTimeMillis();
    }

    @Override
    public void run() {
        try {
            if (this.status.get() == Status.PENDING) {
                this.runner = Thread.currentThread();
                T result = this.action.run();
                if (this.status.compareAndSet(Status.PENDING, Status.SUCCESS)) {
                    this.promise.deliverResult(result);
                }
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
        }
        catch (Exception e) {
            if (this.status.compareAndSet(Status.PENDING, Status.ERROR)) {
                this.promise.deliverError(e);
            }
        }
        finally {
            this.done();
        }
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(this.millisAbsoluteTimeout - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed o) {
        if (o instanceof ResilientTask) {
            return Long.compare(this.millisAbsoluteTimeout, ((ResilientTask)o).millisAbsoluteTimeout);
        }
        return Long.compare(this.getDelay(TimeUnit.MILLISECONDS), o.getDelay(TimeUnit.MILLISECONDS));
    }

    public void setTimedOut() {
        if (this.status.get() == Status.PENDING && this.status.compareAndSet(Status.PENDING, Status.TIMEOUT)) {
            this.promise.setTimedOut();
            if (this.runner != null) {
                this.runner.interrupt();
            }
        }
    }

    private void done() {
        this.metrics.incrementMetricCount(Metric.statusToMetric(this.status.get()));
        this.breaker.informBreakerOfResult(this.status.get() == Status.SUCCESS);
        try {
            if (this.callback != null) {
                this.callback.run(this.promise);
            }
        }
        catch (Exception exception) {
        }
        finally {
            this.semaphore.releasePermit();
        }
    }
}

