/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReferenceArray;
import net.uncontended.precipice.metrics.ActionMetrics;
import net.uncontended.precipice.metrics.HealthSnapshot;
import net.uncontended.precipice.metrics.Metric;
import net.uncontended.precipice.metrics.Slot;
import net.uncontended.precipice.metrics.Snapshot;
import net.uncontended.precipice.utils.SystemTime;

public class DefaultActionMetrics
implements ActionMetrics {
    private final AtomicReferenceArray<Slot> metrics;
    private final SystemTime systemTime;
    private final int mask;
    private final int totalSlots;
    private final int millisecondsPerSlot;
    private final long startTime;

    public DefaultActionMetrics() {
        this(3600, 1L, TimeUnit.SECONDS);
    }

    public DefaultActionMetrics(int slotsToTrack, long resolution, TimeUnit slotUnit) {
        this(slotsToTrack, resolution, slotUnit, new SystemTime());
    }

    public DefaultActionMetrics(int slotsToTrack, long resolution, TimeUnit slotUnit, SystemTime systemTime) {
        this.systemTime = systemTime;
        long millisecondsPerSlot = TimeUnit.MILLISECONDS.convert(resolution, slotUnit);
        if (millisecondsPerSlot < 0L) {
            throw new IllegalArgumentException(String.format("Too low of resolution. %s milliseconds per slot is the lowest valid resolution", Integer.MAX_VALUE));
        }
        if (100L > millisecondsPerSlot) {
            throw new IllegalArgumentException(String.format("Too low of resolution: [%s milliseconds]. 100 milliseconds is the minimum resolution.", millisecondsPerSlot));
        }
        this.millisecondsPerSlot = (int)millisecondsPerSlot;
        this.startTime = systemTime.currentTimeMillis();
        this.totalSlots = slotsToTrack;
        int arraySlot = this.nextPositivePowerOfTwo(slotsToTrack);
        this.mask = arraySlot - 1;
        this.metrics = new AtomicReferenceArray(arraySlot);
        for (int i = 0; i < arraySlot; ++i) {
            this.metrics.set(i, new Slot(i));
        }
    }

    @Override
    public void incrementMetricCount(Metric metric) {
        block3: {
            long currentTime = this.systemTime.currentTimeMillis();
            int absoluteSlot = this.currentAbsoluteSlot(currentTime);
            int relativeSlot = absoluteSlot & this.mask;
            Slot slot = this.metrics.get(relativeSlot);
            if (slot.getAbsoluteSlot() == (long)absoluteSlot) {
                slot.incrementMetric(metric);
            } else {
                Slot newSlot;
                do {
                    if ((slot = this.metrics.get(relativeSlot)).getAbsoluteSlot() != (long)absoluteSlot) continue;
                    slot.incrementMetric(metric);
                    break block3;
                } while (!this.metrics.compareAndSet(relativeSlot, slot, newSlot = new Slot(absoluteSlot)));
                newSlot.incrementMetric(metric);
            }
        }
    }

    @Override
    public long getMetricCountForTimePeriod(Metric metric, long timePeriod, TimeUnit timeUnit) {
        int slots = this.convertToSlots(timePeriod, timeUnit);
        long currentTime = this.systemTime.currentTimeMillis();
        int absoluteSlot = this.currentAbsoluteSlot(currentTime);
        int startSlot = 1 + absoluteSlot - slots;
        int adjustedStartSlot = startSlot >= 0 ? startSlot : 0;
        long count = 0L;
        for (int i = adjustedStartSlot; i <= absoluteSlot; ++i) {
            int relativeSlot = i & this.mask;
            Slot slot = this.metrics.get(relativeSlot);
            if (slot.getAbsoluteSlot() != (long)i) continue;
            count += slot.getMetric(metric).longValue();
        }
        return count;
    }

    @Override
    public HealthSnapshot healthSnapshot(long timePeriod, TimeUnit timeUnit) {
        int slots = this.convertToSlots(timePeriod, timeUnit);
        Slot[] slotArray = this.collectActiveSlots(slots);
        long total = 0L;
        long failures = 0L;
        long rejections = 0L;
        for (Slot slot : slotArray) {
            if (slot == null) continue;
            long successes = slot.getMetric(Metric.SUCCESS).longValue();
            long errors = slot.getMetric(Metric.ERROR).longValue();
            long timeouts = slot.getMetric(Metric.TIMEOUT).longValue();
            long maxConcurrency = slot.getMetric(Metric.MAX_CONCURRENCY_LEVEL_EXCEEDED).longValue();
            long circuitOpen = slot.getMetric(Metric.CIRCUIT_OPEN).longValue();
            long queueFull = slot.getMetric(Metric.QUEUE_FULL).longValue();
            long slotTotal = successes + errors + timeouts + maxConcurrency + circuitOpen + queueFull;
            total += slotTotal;
            failures = failures + errors + timeouts;
            rejections = rejections + circuitOpen + queueFull + maxConcurrency;
        }
        return new HealthSnapshot(total, failures, rejections);
    }

    @Override
    public Map<Object, Object> snapshot(long timePeriod, TimeUnit timeUnit) {
        int slots = this.convertToSlots(timePeriod, timeUnit);
        return Snapshot.generate(this.collectActiveSlots(slots));
    }

    private Slot[] collectActiveSlots(int slots) {
        long currentTime = this.systemTime.currentTimeMillis();
        int absoluteSlot = this.currentAbsoluteSlot(currentTime);
        int startSlot = 1 + absoluteSlot - slots;
        int adjustedStartSlot = startSlot >= 0 ? startSlot : 0;
        Slot[] slotArray = new Slot[slots];
        int j = 0;
        for (int i = adjustedStartSlot; i <= absoluteSlot; ++i) {
            int relativeSlot = i & this.mask;
            Slot slot = this.metrics.get(relativeSlot);
            if (slot.getAbsoluteSlot() == (long)i) {
                slotArray[j] = slot;
            }
            ++j;
        }
        return slotArray;
    }

    private int currentAbsoluteSlot(long currentTime) {
        return (int)(currentTime - this.startTime) / this.millisecondsPerSlot;
    }

    private int convertToSlots(long timePeriod, TimeUnit timeUnit) {
        long longSlots = TimeUnit.MILLISECONDS.convert(timePeriod, timeUnit) / (long)this.millisecondsPerSlot;
        if (longSlots > (long)this.totalSlots) {
            String message = String.format("Slots greater than slots tracked: [Tracked: %s, Argument: %s]", this.totalSlots, longSlots);
            throw new IllegalArgumentException(message);
        }
        if (longSlots <= 0L) {
            String message = String.format("Slots must be greater than 0. [Argument: %s]", longSlots);
            throw new IllegalArgumentException(message);
        }
        return (int)longSlots;
    }

    private int nextPositivePowerOfTwo(int slotsToTrack) {
        return 1 << 32 - Integer.numberOfLeadingZeros(slotsToTrack - 1);
    }
}

