/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics;

import net.uncontended.precipice.Status;

public enum Metric {
    SUCCESS(false),
    ERROR(false),
    TIMEOUT(false),
    CIRCUIT_OPEN(true),
    QUEUE_FULL(true),
    MAX_CONCURRENCY_LEVEL_EXCEEDED(true);

    private final boolean actionRejected;

    private Metric(boolean actionRejected) {
        this.actionRejected = actionRejected;
    }

    public boolean actionRejected() {
        return this.actionRejected;
    }

    public static Metric statusToMetric(Status status) {
        switch (status) {
            case SUCCESS: {
                return SUCCESS;
            }
            case ERROR: {
                return ERROR;
            }
            case TIMEOUT: {
                return TIMEOUT;
            }
        }
        throw new RuntimeException("Cannot convert Status to Metric: " + (Object)((Object)status));
    }
}

