/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.metrics;

import net.uncontended.precipice.concurrent.LongAdder;
import net.uncontended.precipice.metrics.Metric;

public class Slot {
    private final LongAdder successes = new LongAdder();
    private final LongAdder errors = new LongAdder();
    private final LongAdder timeouts = new LongAdder();
    private final LongAdder circuitOpen = new LongAdder();
    private final LongAdder queueFull = new LongAdder();
    private final LongAdder maxConcurrencyExceeded = new LongAdder();
    private final long second;

    public Slot(long second) {
        this.second = second;
    }

    public void incrementMetric(Metric metric) {
        switch (metric) {
            case SUCCESS: {
                this.successes.increment();
                break;
            }
            case ERROR: {
                this.errors.increment();
                break;
            }
            case TIMEOUT: {
                this.timeouts.increment();
                break;
            }
            case CIRCUIT_OPEN: {
                this.circuitOpen.increment();
                break;
            }
            case QUEUE_FULL: {
                this.queueFull.increment();
                break;
            }
            case MAX_CONCURRENCY_LEVEL_EXCEEDED: {
                this.maxConcurrencyExceeded.increment();
                break;
            }
            default: {
                throw new RuntimeException("Unknown metric: " + (Object)((Object)metric));
            }
        }
    }

    public LongAdder getMetric(Metric metric) {
        switch (metric) {
            case SUCCESS: {
                return this.successes;
            }
            case ERROR: {
                return this.errors;
            }
            case TIMEOUT: {
                return this.timeouts;
            }
            case CIRCUIT_OPEN: {
                return this.circuitOpen;
            }
            case QUEUE_FULL: {
                return this.queueFull;
            }
            case MAX_CONCURRENCY_LEVEL_EXCEEDED: {
                return this.maxConcurrencyExceeded;
            }
        }
        throw new RuntimeException("Unknown metric: " + (Object)((Object)metric));
    }

    public long getAbsoluteSlot() {
        return this.second;
    }

    public String toString() {
        return "Slot{successes=" + this.successes + ", errors=" + this.errors + ", timeouts=" + this.timeouts + ", circuitOpen=" + this.circuitOpen + ", queueFull=" + this.queueFull + ", maxConcurrencyExceeded=" + this.maxConcurrencyExceeded + ", second=" + this.second + '}';
    }
}

