/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.Map;
import net.uncontended.precipice.MultiService;
import net.uncontended.precipice.RejectedActionException;
import net.uncontended.precipice.RejectionReason;
import net.uncontended.precipice.ResilientCallback;
import net.uncontended.precipice.concurrent.ResilientFuture;
import net.uncontended.precipice.concurrent.ResilientPromise;
import net.uncontended.precipice.pattern.LoadBalancerStrategy;
import net.uncontended.precipice.pattern.MultiPattern;
import net.uncontended.precipice.pattern.ResilientActionWithContext;
import net.uncontended.precipice.pattern.ResilientPatternAction;

public class LoadBalancer<C>
implements MultiPattern<C> {
    private final MultiService[] services;
    private final C[] contexts;
    private final LoadBalancerStrategy strategy;

    public LoadBalancer(Map<MultiService, C> executorToContext, LoadBalancerStrategy strategy) {
        if (executorToContext.size() == 0) {
            throw new IllegalArgumentException("Cannot create LoadBalancer with 0 Executors.");
        }
        this.strategy = strategy;
        this.services = new MultiService[executorToContext.size()];
        this.contexts = new Object[executorToContext.size()];
        int i = 0;
        for (Map.Entry<MultiService, C> entry : executorToContext.entrySet()) {
            this.services[i] = entry.getKey();
            this.contexts[i] = entry.getValue();
            ++i;
        }
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientPatternAction<T, C> action, long millisTimeout) {
        return this.submit(action, null, millisTimeout);
    }

    @Override
    public <T> ResilientFuture<T> submit(ResilientPatternAction<T, C> action, ResilientCallback<T> callback, long millisTimeout) {
        int firstServiceToTry = this.strategy.nextExecutorIndex();
        ResilientActionWithContext<T, C> actionWithContext = new ResilientActionWithContext<T, C>(action);
        int j = 0;
        int serviceCount = this.services.length;
        while (true) {
            try {
                int serviceIndex = (firstServiceToTry + j) % serviceCount;
                actionWithContext.context = this.contexts[serviceIndex];
                return this.services[serviceIndex].submit(actionWithContext, callback, millisTimeout);
            }
            catch (RejectedActionException e) {
                if (++j != serviceCount) continue;
                throw new RejectedActionException(RejectionReason.ALL_SERVICES_REJECTED);
            }
            break;
        }
    }

    @Override
    public <T> void submitAndComplete(ResilientPatternAction<T, C> action, ResilientPromise<T> promise, long millisTimeout) {
        this.submitAndComplete(action, promise, null, millisTimeout);
    }

    @Override
    public <T> void submitAndComplete(ResilientPatternAction<T, C> action, ResilientPromise<T> promise, ResilientCallback<T> callback, long millisTimeout) {
        int firstServiceToTry = this.strategy.nextExecutorIndex();
        ResilientActionWithContext<T, C> actionWithContext = new ResilientActionWithContext<T, C>(action);
        int j = 0;
        int serviceCount = this.services.length;
        while (true) {
            try {
                int serviceIndex = (firstServiceToTry + j) % serviceCount;
                actionWithContext.context = this.contexts[serviceIndex];
                this.services[serviceIndex].submitAndComplete(actionWithContext, promise, callback, millisTimeout);
            }
            catch (RejectedActionException e) {
                if (++j != serviceCount) continue;
                throw new RejectedActionException(RejectionReason.ALL_SERVICES_REJECTED);
            }
            break;
        }
    }

    @Override
    public <T> T run(ResilientPatternAction<T, C> action) throws Exception {
        int firstServiceToTry = this.strategy.nextExecutorIndex();
        ResilientActionWithContext<T, C> actionWithContext = new ResilientActionWithContext<T, C>(action);
        int j = 0;
        int serviceCount = this.services.length;
        while (true) {
            try {
                int serviceIndex = (firstServiceToTry + j) % serviceCount;
                actionWithContext.context = this.contexts[serviceIndex];
                return this.services[serviceIndex].run(actionWithContext);
            }
            catch (RejectedActionException e) {
                if (++j != serviceCount) continue;
                throw new RejectedActionException(RejectionReason.ALL_SERVICES_REJECTED);
            }
            break;
        }
    }

    @Override
    public void shutdown() {
        for (MultiService e : this.services) {
            e.shutdown();
        }
    }
}

