/*
 * Decompiled with CFR 0.152.
 */
package net.uncontended.precipice.pattern;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import net.uncontended.precipice.MultiService;
import net.uncontended.precipice.Services;
import net.uncontended.precipice.circuit.BreakerConfig;
import net.uncontended.precipice.circuit.BreakerConfigBuilder;
import net.uncontended.precipice.circuit.DefaultCircuitBreaker;
import net.uncontended.precipice.metrics.DefaultActionMetrics;
import net.uncontended.precipice.pattern.LoadBalancer;
import net.uncontended.precipice.pattern.MultiPattern;
import net.uncontended.precipice.pattern.RoundRobinStrategy;
import net.uncontended.precipice.utils.PrecipiceExecutors;

public class LoadBalancers {
    public static <C> MultiPattern<C> newRoundRobin(Map<MultiService, C> serviceToContext) {
        return new LoadBalancer<C>(serviceToContext, new RoundRobinStrategy(serviceToContext.size()));
    }

    public static <C> MultiPattern<C> newRoundRobinWithSharedPool(List<C> contexts, String name, int poolSize, int concurrencyLevel) {
        ExecutorService executor = PrecipiceExecutors.threadPoolExecutor(name, poolSize, concurrencyLevel);
        HashMap<MultiService, C> serviceToContext = new HashMap<MultiService, C>();
        for (C context : contexts) {
            BreakerConfig configBuilder = new BreakerConfigBuilder().build();
            DefaultActionMetrics metrics = new DefaultActionMetrics();
            MultiService service = Services.defaultService(executor, concurrencyLevel, metrics, new DefaultCircuitBreaker(metrics, configBuilder));
            serviceToContext.put(service, context);
        }
        return new LoadBalancer(serviceToContext, new RoundRobinStrategy(contexts.size()));
    }
}

